/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for WafMetric.
 */
public final class WafMetric extends ExpandableStringEnum<WafMetric> {
    /** Static value clientRequestCount for WafMetric. */
    public static final WafMetric CLIENT_REQUEST_COUNT = fromString("clientRequestCount");

    /**
     * Creates or finds a WafMetric from its string representation.
     * @param name a name to look for
     * @return the corresponding WafMetric
     */
    @JsonCreator
    public static WafMetric fromString(String name) {
        return fromString(name, WafMetric.class);
    }

    /**
     * @return known WafMetric values
     */
    public static Collection<WafMetric> values() {
        return values(WafMetric.class);
    }
}
