/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The WafMetricsResponseSeriesItem model.
 */
public class WafMetricsResponseSeriesItem {
    /**
     * The metric property.
     */
    @JsonProperty(value = "metric")
    private String metric;

    /**
     * Possible values include: 'count'.
     */
    @JsonProperty(value = "unit")
    private String unit;

    /**
     * The groups property.
     */
    @JsonProperty(value = "groups")
    private List<WafMetricsResponseSeriesItemGroupsItem> groups;

    /**
     * The data property.
     */
    @JsonProperty(value = "data")
    private List<WafMetricsResponseSeriesItemDataItem> data;

    /**
     * Get the metric value.
     *
     * @return the metric value
     */
    public String metric() {
        return this.metric;
    }

    /**
     * Set the metric value.
     *
     * @param metric the metric value to set
     * @return the WafMetricsResponseSeriesItem object itself.
     */
    public WafMetricsResponseSeriesItem withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    /**
     * Get possible values include: 'count'.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set possible values include: 'count'.
     *
     * @param unit the unit value to set
     * @return the WafMetricsResponseSeriesItem object itself.
     */
    public WafMetricsResponseSeriesItem withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the groups value.
     *
     * @return the groups value
     */
    public List<WafMetricsResponseSeriesItemGroupsItem> groups() {
        return this.groups;
    }

    /**
     * Set the groups value.
     *
     * @param groups the groups value to set
     * @return the WafMetricsResponseSeriesItem object itself.
     */
    public WafMetricsResponseSeriesItem withGroups(List<WafMetricsResponseSeriesItemGroupsItem> groups) {
        this.groups = groups;
        return this;
    }

    /**
     * Get the data value.
     *
     * @return the data value
     */
    public List<WafMetricsResponseSeriesItemDataItem> data() {
        return this.data;
    }

    /**
     * Set the data value.
     *
     * @param data the data value to set
     * @return the WafMetricsResponseSeriesItem object itself.
     */
    public WafMetricsResponseSeriesItem withData(List<WafMetricsResponseSeriesItemDataItem> data) {
        this.data = data;
        return this;
    }

}
