/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AFDDomainHttpsParameters;
import com.microsoft.azure.management.cdn.AFDDomainUpdateParameters;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.ResourceReference;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;

/**
 * An instance of this class provides access to all the operations defined
 * in AFDCustomDomains.
 */
public class AFDCustomDomainsInner {
    /** The Retrofit service to perform REST calls. */
    private AFDCustomDomainsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of AFDCustomDomainsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AFDCustomDomainsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(AFDCustomDomainsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AFDCustomDomains to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AFDCustomDomainsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains listByProfile" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains")
        Observable<Response<ResponseBody>> listByProfile(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Body AFDDomainInner customDomain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Body AFDDomainInner customDomain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body AFDDomainUpdateParameters customDomainUpdateProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body AFDDomainUpdateParameters customDomainUpdateProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains refreshValidationToken" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}/refreshValidationToken")
        Observable<Response<ResponseBody>> refreshValidationToken(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains beginRefreshValidationToken" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}/refreshValidationToken")
        Observable<Response<ResponseBody>> beginRefreshValidationToken(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDCustomDomains listByProfileNext" })
        @GET
        Observable<Response<ResponseBody>> listByProfileNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AFDDomainInner&gt; object if successful.
     */
    public PagedList<AFDDomainInner> listByProfile(final String resourceGroupName, final String profileName) {
        ServiceResponse<Page<AFDDomainInner>> response = listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<AFDDomainInner>(response.body()) {
            @Override
            public Page<AFDDomainInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AFDDomainInner>> listByProfileAsync(final String resourceGroupName, final String profileName, final ListOperationCallback<AFDDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileSinglePageAsync(resourceGroupName, profileName),
            new Func1<String, Observable<ServiceResponse<Page<AFDDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDDomainInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDDomainInner&gt; object
     */
    public Observable<Page<AFDDomainInner>> listByProfileAsync(final String resourceGroupName, final String profileName) {
        return listByProfileWithServiceResponseAsync(resourceGroupName, profileName)
            .map(new Func1<ServiceResponse<Page<AFDDomainInner>>, Page<AFDDomainInner>>() {
                @Override
                public Page<AFDDomainInner> call(ServiceResponse<Page<AFDDomainInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDDomainInner&gt; object
     */
    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileWithServiceResponseAsync(final String resourceGroupName, final String profileName) {
        return listByProfileSinglePageAsync(resourceGroupName, profileName)
            .concatMap(new Func1<ServiceResponse<Page<AFDDomainInner>>, Observable<ServiceResponse<Page<AFDDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDDomainInner>>> call(ServiceResponse<Page<AFDDomainInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
    ServiceResponse<PageImpl<AFDDomainInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<AFDDomainInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AFDDomainInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileSinglePageAsync(final String resourceGroupName, final String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDDomainInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AFDDomainInner>> result = listByProfileDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AFDDomainInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AFDDomainInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AFDDomainInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AFDDomainInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner get(String resourceGroupName, String profileName, String customDomainName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single().body();
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<AFDDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<ServiceResponse<AFDDomainInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDDomainInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AFDDomainInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AFDDomainInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AFDDomainInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner create(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).toBlocking().last().body();
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> createAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain), serviceCallback);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AFDDomainInner> createAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AFDDomainInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (customDomain == null) {
            throw new IllegalArgumentException("Parameter customDomain is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(customDomain);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), customDomain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDDomainInner>() { }.getType());
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner beginCreate(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).toBlocking().single().body();
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain), serviceCallback);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<AFDDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, customDomain).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param customDomain Domain properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<ServiceResponse<AFDDomainInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainInner customDomain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (customDomain == null) {
            throw new IllegalArgumentException("Parameter customDomain is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(customDomain);
        return service.beginCreate(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), customDomain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDDomainInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AFDDomainInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AFDDomainInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AFDDomainInner>() { }.getType())
                .register(201, new TypeToken<AFDDomainInner>() { }.getType())
                .register(202, new TypeToken<AFDDomainInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner update(String resourceGroupName, String profileName, String customDomainName) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().last().body();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AFDDomainInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final AFDDomainHttpsParameters tlsSettings = null;
        final ResourceReference azureDnsZone = null;
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(null);
        customDomainUpdateProperties.withAzureDnsZone(null);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDDomainInner>() { }.getType());
    }
    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner update(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).toBlocking().last().body();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone), serviceCallback);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AFDDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AFDDomainInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tlsSettings);
        Validator.validate(azureDnsZone);
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDDomainInner>() { }.getType());
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner beginUpdate(String resourceGroupName, String profileName, String customDomainName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single().body();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<ServiceResponse<AFDDomainInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final AFDDomainHttpsParameters tlsSettings = null;
        final ResourceReference azureDnsZone = null;
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(null);
        customDomainUpdateProperties.withAzureDnsZone(null);
        return service.beginUpdate(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDDomainInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDDomainInner object if successful.
     */
    public AFDDomainInner beginUpdate(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).toBlocking().single().body();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, final ServiceCallback<AFDDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone), serviceCallback);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<AFDDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).map(new Func1<ServiceResponse<AFDDomainInner>, AFDDomainInner>() {
            @Override
            public AFDDomainInner call(ServiceResponse<AFDDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDDomainInner object
     */
    public Observable<ServiceResponse<AFDDomainInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName, AFDDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tlsSettings);
        Validator.validate(azureDnsZone);
        AFDDomainUpdateParameters customDomainUpdateProperties = new AFDDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        return service.beginUpdate(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainUpdateProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDDomainInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AFDDomainInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AFDDomainInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AFDDomainInner>() { }.getType())
                .register(202, new TypeToken<AFDDomainInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String customDomainName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().last().body();
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String customDomainName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single().body();
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ValidationTokenInner object if successful.
     */
    public ValidationTokenInner refreshValidationToken(String resourceGroupName, String profileName, String customDomainName) {
        return refreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().last().body();
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ValidationTokenInner> refreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<ValidationTokenInner> serviceCallback) {
        return ServiceFuture.fromResponse(refreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ValidationTokenInner> refreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName) {
        return refreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<ValidationTokenInner>, ValidationTokenInner>() {
            @Override
            public ValidationTokenInner call(ServiceResponse<ValidationTokenInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<ValidationTokenInner>> refreshValidationTokenWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.refreshValidationToken(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.AZURE_ASYNC_OPERATION), new TypeToken<ValidationTokenInner>() { }.getType());
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ValidationTokenInner object if successful.
     */
    public ValidationTokenInner beginRefreshValidationToken(String resourceGroupName, String profileName, String customDomainName) {
        return beginRefreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).toBlocking().single().body();
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ValidationTokenInner> beginRefreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName, final ServiceCallback<ValidationTokenInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginRefreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName), serviceCallback);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidationTokenInner object
     */
    public Observable<ValidationTokenInner> beginRefreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName) {
        return beginRefreshValidationTokenWithServiceResponseAsync(resourceGroupName, profileName, customDomainName).map(new Func1<ServiceResponse<ValidationTokenInner>, ValidationTokenInner>() {
            @Override
            public ValidationTokenInner call(ServiceResponse<ValidationTokenInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidationTokenInner object
     */
    public Observable<ServiceResponse<ValidationTokenInner>> beginRefreshValidationTokenWithServiceResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginRefreshValidationToken(resourceGroupName, profileName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidationTokenInner>>>() {
                @Override
                public Observable<ServiceResponse<ValidationTokenInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ValidationTokenInner> clientResponse = beginRefreshValidationTokenDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ValidationTokenInner> beginRefreshValidationTokenDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ValidationTokenInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ValidationTokenInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AFDDomainInner&gt; object if successful.
     */
    public PagedList<AFDDomainInner> listByProfileNext(final String nextPageLink) {
        ServiceResponse<Page<AFDDomainInner>> response = listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AFDDomainInner>(response.body()) {
            @Override
            public Page<AFDDomainInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AFDDomainInner>> listByProfileNextAsync(final String nextPageLink, final ServiceFuture<List<AFDDomainInner>> serviceFuture, final ListOperationCallback<AFDDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AFDDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDDomainInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDDomainInner&gt; object
     */
    public Observable<Page<AFDDomainInner>> listByProfileNextAsync(final String nextPageLink) {
        return listByProfileNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AFDDomainInner>>, Page<AFDDomainInner>>() {
                @Override
                public Page<AFDDomainInner> call(ServiceResponse<Page<AFDDomainInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDDomainInner&gt; object
     */
    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileNextWithServiceResponseAsync(final String nextPageLink) {
        return listByProfileNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AFDDomainInner>>, Observable<ServiceResponse<Page<AFDDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDDomainInner>>> call(ServiceResponse<Page<AFDDomainInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
    ServiceResponse<PageImpl<AFDDomainInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AFDDomainInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AFDDomainInner>>> listByProfileNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDDomainInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AFDDomainInner>> result = listByProfileNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AFDDomainInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AFDDomainInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AFDDomainInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AFDDomainInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
