/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.RouteUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Routes.
 */
public class RoutesInner {
    /** The Retrofit service to perform REST calls. */
    private RoutesService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of RoutesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RoutesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(RoutesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Routes to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RoutesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes listByEndpoint" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes")
        Observable<Response<ResponseBody>> listByEndpoint(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Body RouteInner route, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Body RouteInner route, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Body RouteUpdateParameters routeUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Body RouteUpdateParameters routeUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("routeName") String routeName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Routes listByEndpointNext" })
        @GET
        Observable<Response<ResponseBody>> listByEndpointNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RouteInner&gt; object if successful.
     */
    public PagedList<RouteInner> listByEndpoint(final String resourceGroupName, final String profileName, final String endpointName) {
        ServiceResponse<Page<RouteInner>> response = listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<RouteInner>(response.body()) {
            @Override
            public Page<RouteInner> nextPage(String nextPageLink) {
                return listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RouteInner>> listByEndpointAsync(final String resourceGroupName, final String profileName, final String endpointName, final ListOperationCallback<RouteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName),
            new Func1<String, Observable<ServiceResponse<Page<RouteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteInner>>> call(String nextPageLink) {
                    return listByEndpointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RouteInner&gt; object
     */
    public Observable<Page<RouteInner>> listByEndpointAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName)
            .map(new Func1<ServiceResponse<Page<RouteInner>>, Page<RouteInner>>() {
                @Override
                public Page<RouteInner> call(ServiceResponse<Page<RouteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RouteInner&gt; object
     */
    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName)
            .concatMap(new Func1<ServiceResponse<Page<RouteInner>>, Observable<ServiceResponse<Page<RouteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteInner>>> call(ServiceResponse<Page<RouteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEndpointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing origins within a profile.
     *
    ServiceResponse<PageImpl<RouteInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<RouteInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<RouteInner>> * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RouteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointSinglePageAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RouteInner>> result = listByEndpointDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RouteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RouteInner>> listByEndpointDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RouteInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RouteInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RouteInner object if successful.
     */
    public RouteInner get(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).toBlocking().single().body();
    }

    /**
     * Gets an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RouteInner> getAsync(String resourceGroupName, String profileName, String endpointName, String routeName, final ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName), serviceCallback);
    }

    /**
     * Gets an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RouteInner object
     */
    public Observable<RouteInner> getAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).map(new Func1<ServiceResponse<RouteInner>, RouteInner>() {
            @Override
            public RouteInner call(ServiceResponse<RouteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RouteInner object
     */
    public Observable<ServiceResponse<RouteInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteInner>>>() {
                @Override
                public Observable<ServiceResponse<RouteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RouteInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RouteInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RouteInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RouteInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RouteInner object if successful.
     */
    public RouteInner create(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).toBlocking().last().body();
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RouteInner> createAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, final ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route), serviceCallback);
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RouteInner> createAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).map(new Func1<ServiceResponse<RouteInner>, RouteInner>() {
            @Override
            public RouteInner call(ServiceResponse<RouteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RouteInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (route == null) {
            throw new IllegalArgumentException("Parameter route is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(route);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), route, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteInner>() { }.getType());
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RouteInner object if successful.
     */
    public RouteInner beginCreate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).toBlocking().single().body();
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RouteInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, final ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route), serviceCallback);
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RouteInner object
     */
    public Observable<RouteInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, route).map(new Func1<ServiceResponse<RouteInner>, RouteInner>() {
            @Override
            public RouteInner call(ServiceResponse<RouteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param route Route properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RouteInner object
     */
    public Observable<ServiceResponse<RouteInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (route == null) {
            throw new IllegalArgumentException("Parameter route is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(route);
        return service.beginCreate(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), route, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteInner>>>() {
                @Override
                public Observable<ServiceResponse<RouteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RouteInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RouteInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RouteInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RouteInner>() { }.getType())
                .register(201, new TypeToken<RouteInner>() { }.getType())
                .register(202, new TypeToken<RouteInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RouteInner object if successful.
     */
    public RouteInner update(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).toBlocking().last().body();
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RouteInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, final ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RouteInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).map(new Func1<ServiceResponse<RouteInner>, RouteInner>() {
            @Override
            public RouteInner call(ServiceResponse<RouteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RouteInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter routeUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(routeUpdateProperties);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), routeUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RouteInner>() { }.getType());
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RouteInner object if successful.
     */
    public RouteInner beginUpdate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).toBlocking().single().body();
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RouteInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, final ServiceCallback<RouteInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RouteInner object
     */
    public Observable<RouteInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).map(new Func1<ServiceResponse<RouteInner>, RouteInner>() {
            @Override
            public RouteInner call(ServiceResponse<RouteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param routeUpdateProperties Route update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RouteInner object
     */
    public Observable<ServiceResponse<RouteInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (routeUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter routeUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(routeUpdateProperties);
        return service.beginUpdate(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), routeUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RouteInner>>>() {
                @Override
                public Observable<ServiceResponse<RouteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RouteInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RouteInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RouteInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RouteInner>() { }.getType())
                .register(202, new TypeToken<RouteInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String endpointName, String routeName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).toBlocking().last().body();
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName), serviceCallback);
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String endpointName, String routeName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).toBlocking().single().body();
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName), serviceCallback);
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, routeName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing route with the specified route name under the specified subscription, resource group, profile, and AzureFrontDoor endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param routeName Name of the routing rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (routeName == null) {
            throw new IllegalArgumentException("Parameter routeName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, endpointName, routeName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RouteInner&gt; object if successful.
     */
    public PagedList<RouteInner> listByEndpointNext(final String nextPageLink) {
        ServiceResponse<Page<RouteInner>> response = listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RouteInner>(response.body()) {
            @Override
            public Page<RouteInner> nextPage(String nextPageLink) {
                return listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RouteInner>> listByEndpointNextAsync(final String nextPageLink, final ServiceFuture<List<RouteInner>> serviceFuture, final ListOperationCallback<RouteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEndpointNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RouteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteInner>>> call(String nextPageLink) {
                    return listByEndpointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RouteInner&gt; object
     */
    public Observable<Page<RouteInner>> listByEndpointNextAsync(final String nextPageLink) {
        return listByEndpointNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RouteInner>>, Page<RouteInner>>() {
                @Override
                public Page<RouteInner> call(ServiceResponse<Page<RouteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing origins within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RouteInner&gt; object
     */
    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointNextWithServiceResponseAsync(final String nextPageLink) {
        return listByEndpointNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RouteInner>>, Observable<ServiceResponse<Page<RouteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteInner>>> call(ServiceResponse<Page<RouteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEndpointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing origins within a profile.
     *
    ServiceResponse<PageImpl<RouteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RouteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RouteInner>>> listByEndpointNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RouteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RouteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RouteInner>> result = listByEndpointNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RouteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RouteInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RouteInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RouteInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
