/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.SecurityPolicyParameters;
import com.microsoft.azure.management.cdn.SecurityPolicyProperties;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in SecurityPolicies.
 */
public class SecurityPoliciesInner {
    /** The Retrofit service to perform REST calls. */
    private SecurityPoliciesService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of SecurityPoliciesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public SecurityPoliciesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(SecurityPoliciesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for SecurityPolicies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface SecurityPoliciesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies listByProfile" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies")
        Observable<Response<ResponseBody>> listByProfile(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecurityPolicyInner securityPolicy, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecurityPolicyInner securityPolicy, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies patch" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        Observable<Response<ResponseBody>> patch(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecurityPolicyProperties securityPolicyProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies beginPatch" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}")
        Observable<Response<ResponseBody>> beginPatch(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecurityPolicyProperties securityPolicyProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/securityPolicies/{securityPolicyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("securityPolicyName") String securityPolicyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.SecurityPolicies listByProfileNext" })
        @GET
        Observable<Response<ResponseBody>> listByProfileNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecurityPolicyInner&gt; object if successful.
     */
    public PagedList<SecurityPolicyInner> listByProfile(final String resourceGroupName, final String profileName) {
        ServiceResponse<Page<SecurityPolicyInner>> response = listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<SecurityPolicyInner>(response.body()) {
            @Override
            public Page<SecurityPolicyInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SecurityPolicyInner>> listByProfileAsync(final String resourceGroupName, final String profileName, final ListOperationCallback<SecurityPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileSinglePageAsync(resourceGroupName, profileName),
            new Func1<String, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecurityPolicyInner&gt; object
     */
    public Observable<Page<SecurityPolicyInner>> listByProfileAsync(final String resourceGroupName, final String profileName) {
        return listByProfileWithServiceResponseAsync(resourceGroupName, profileName)
            .map(new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Page<SecurityPolicyInner>>() {
                @Override
                public Page<SecurityPolicyInner> call(ServiceResponse<Page<SecurityPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecurityPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileWithServiceResponseAsync(final String resourceGroupName, final String profileName) {
        return listByProfileSinglePageAsync(resourceGroupName, profileName)
            .concatMap(new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(ServiceResponse<Page<SecurityPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists security policies associated with the profile.
     *
    ServiceResponse<PageImpl<SecurityPolicyInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<SecurityPolicyInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SecurityPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileSinglePageAsync(final String resourceGroupName, final String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SecurityPolicyInner>> result = listByProfileDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SecurityPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SecurityPolicyInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SecurityPolicyInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SecurityPolicyInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing security policy within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner get(String resourceGroupName, String profileName, String securityPolicyName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single().body();
    }

    /**
     * Gets an existing security policy within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> getAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Gets an existing security policy within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<SecurityPolicyInner> getAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing security policy within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecurityPolicyInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SecurityPolicyInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SecurityPolicyInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SecurityPolicyInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner create(String resourceGroupName, String profileName, String securityPolicyName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().last().body();
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecurityPolicyParameters parameters = null;
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(null);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>() { }.getType());
    }
    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner create(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().last().body();
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecurityPolicyInner> createAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>() { }.getType());
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner beginCreate(String resourceGroupName, String profileName, String securityPolicyName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single().body();
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecurityPolicyParameters parameters = null;
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(null);
        return service.beginCreate(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecurityPolicyInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner beginCreate(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<SecurityPolicyInner> beginCreateAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new security policy within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecurityPolicyInner securityPolicy = new SecurityPolicyInner();
        securityPolicy.withParameters(parameters);
        return service.beginCreate(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicy, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecurityPolicyInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SecurityPolicyInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SecurityPolicyInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SecurityPolicyInner>() { }.getType())
                .register(201, new TypeToken<SecurityPolicyInner>() { }.getType())
                .register(202, new TypeToken<SecurityPolicyInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner patch(String resourceGroupName, String profileName, String securityPolicyName) {
        return patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().last().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> patchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecurityPolicyParameters parameters = null;
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(null);
        Observable<Response<ResponseBody>> observable = service.patch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>() { }.getType());
    }
    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner patch(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().last().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecurityPolicyInner> patchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return patchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> patchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = service.patch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecurityPolicyInner>() { }.getType());
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner beginPatch(String resourceGroupName, String profileName, String securityPolicyName) {
        return beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecurityPolicyParameters parameters = null;
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(null);
        return service.beginPatch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecurityPolicyInner> clientResponse = beginPatchDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecurityPolicyInner object if successful.
     */
    public SecurityPolicyInner beginPatch(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).toBlocking().single().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters, final ServiceCallback<SecurityPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<SecurityPolicyInner> beginPatchAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        return beginPatchWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName, parameters).map(new Func1<ServiceResponse<SecurityPolicyInner>, SecurityPolicyInner>() {
            @Override
            public SecurityPolicyInner call(ServiceResponse<SecurityPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the security policy under the profile.
     * @param parameters object which contains security policy parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecurityPolicyInner object
     */
    public Observable<ServiceResponse<SecurityPolicyInner>> beginPatchWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName, SecurityPolicyParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecurityPolicyProperties securityPolicyProperties = new SecurityPolicyProperties();
        securityPolicyProperties.withParameters(parameters);
        return service.beginPatch(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), securityPolicyProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecurityPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<SecurityPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecurityPolicyInner> clientResponse = beginPatchDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SecurityPolicyInner> beginPatchDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SecurityPolicyInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SecurityPolicyInner>() { }.getType())
                .register(202, new TypeToken<SecurityPolicyInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String securityPolicyName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().last().body();
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String securityPolicyName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).toBlocking().single().body();
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String securityPolicyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName), serviceCallback);
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, securityPolicyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing security policy within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param securityPolicyName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String securityPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (securityPolicyName == null) {
            throw new IllegalArgumentException("Parameter securityPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, securityPolicyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecurityPolicyInner&gt; object if successful.
     */
    public PagedList<SecurityPolicyInner> listByProfileNext(final String nextPageLink) {
        ServiceResponse<Page<SecurityPolicyInner>> response = listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecurityPolicyInner>(response.body()) {
            @Override
            public Page<SecurityPolicyInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SecurityPolicyInner>> listByProfileNextAsync(final String nextPageLink, final ServiceFuture<List<SecurityPolicyInner>> serviceFuture, final ListOperationCallback<SecurityPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecurityPolicyInner&gt; object
     */
    public Observable<Page<SecurityPolicyInner>> listByProfileNextAsync(final String nextPageLink) {
        return listByProfileNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Page<SecurityPolicyInner>>() {
                @Override
                public Page<SecurityPolicyInner> call(ServiceResponse<Page<SecurityPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists security policies associated with the profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecurityPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileNextWithServiceResponseAsync(final String nextPageLink) {
        return listByProfileNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SecurityPolicyInner>>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(ServiceResponse<Page<SecurityPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists security policies associated with the profile.
     *
    ServiceResponse<PageImpl<SecurityPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SecurityPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SecurityPolicyInner>>> listByProfileNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecurityPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecurityPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SecurityPolicyInner>> result = listByProfileNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SecurityPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SecurityPolicyInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SecurityPolicyInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SecurityPolicyInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
