/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AFDOriginUpdateParameters;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.AFDOriginInner;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AFDOriginsInner {
    private AFDOriginsService service;
    private CdnManagementClientImpl client;

    public AFDOriginsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (AFDOriginsService)retrofit.create(AFDOriginsService.class);
        this.client = client;
    }

    public PagedList<AFDOriginInner> listByOriginGroup(String resourceGroupName, String profileName, String originGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName).toBlocking().single();
        return new PagedList<AFDOriginInner>((Page)response.body()){

            public Page<AFDOriginInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDOriginsInner.this.listByOriginGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AFDOriginInner>> listByOriginGroupAsync(String resourceGroupName, String profileName, String originGroupName, ListOperationCallback<AFDOriginInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AFDOriginInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginInner>>> call(String nextPageLink) {
                return AFDOriginsInner.this.listByOriginGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AFDOriginInner>> listByOriginGroupAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.listByOriginGroupWithServiceResponseAsync(resourceGroupName, profileName, originGroupName).map((Func1)new Func1<ServiceResponse<Page<AFDOriginInner>>, Page<AFDOriginInner>>(){

            public Page<AFDOriginInner> call(ServiceResponse<Page<AFDOriginInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName) {
        return this.listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<AFDOriginInner>>, Observable<ServiceResponse<Page<AFDOriginInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginInner>>> call(ServiceResponse<Page<AFDOriginInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDOriginsInner.this.listByOriginGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupSinglePageAsync(String resourceGroupName, String profileName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByOriginGroup(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDOriginInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDOriginsInner.this.listByOriginGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AFDOriginInner>> listByOriginGroupDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AFDOriginInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDOriginInner get(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return (AFDOriginInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).toBlocking().single()).body());
    }

    public ServiceFuture<AFDOriginInner> getAsync(String resourceGroupName, String profileName, String originGroupName, String originName, ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName), serviceCallback);
    }

    public Observable<AFDOriginInner> getAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).map((Func1)new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>(){

            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return (AFDOriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginInner>>>(){

            public Observable<ServiceResponse<AFDOriginInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDOriginInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDOriginInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDOriginInner create(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return (AFDOriginInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).toBlocking().last()).body());
    }

    public ServiceFuture<AFDOriginInner> createAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin, ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin), serviceCallback);
    }

    public Observable<AFDOriginInner> createAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).map((Func1)new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>(){

            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return (AFDOriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Parameter origin is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)origin));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), origin, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDOriginInner>(){}.getType());
    }

    public AFDOriginInner beginCreate(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return (AFDOriginInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).toBlocking().single()).body());
    }

    public ServiceFuture<AFDOriginInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin, ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin), serviceCallback);
    }

    public Observable<AFDOriginInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).map((Func1)new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>(){

            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return (AFDOriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Parameter origin is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)origin));
        return this.service.beginCreate(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), origin, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginInner>>>(){

            public Observable<ServiceResponse<AFDOriginInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDOriginInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDOriginInner>(){}.getType()).register(201, new TypeToken<AFDOriginInner>(){}.getType()).register(202, new TypeToken<AFDOriginInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public AFDOriginInner update(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return (AFDOriginInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<AFDOriginInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties, ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties), serviceCallback);
    }

    public Observable<AFDOriginInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).map((Func1)new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>(){

            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return (AFDOriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), originUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDOriginInner>(){}.getType());
    }

    public AFDOriginInner beginUpdate(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return (AFDOriginInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<AFDOriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties, ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties), serviceCallback);
    }

    public Observable<AFDOriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).map((Func1)new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>(){

            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return (AFDOriginInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AFDOriginInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), originUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginInner>>>(){

            public Observable<ServiceResponse<AFDOriginInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AFDOriginInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AFDOriginInner>(){}.getType()).register(202, new TypeToken<AFDOriginInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AFDOriginsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<AFDOriginInner> listByOriginGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByOriginGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AFDOriginInner>((Page)response.body()){

            public Page<AFDOriginInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AFDOriginsInner.this.listByOriginGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AFDOriginInner>> listByOriginGroupNextAsync(String nextPageLink, ServiceFuture<List<AFDOriginInner>> serviceFuture, ListOperationCallback<AFDOriginInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByOriginGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AFDOriginInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginInner>>> call(String nextPageLink) {
                return AFDOriginsInner.this.listByOriginGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AFDOriginInner>> listByOriginGroupNextAsync(String nextPageLink) {
        return this.listByOriginGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AFDOriginInner>>, Page<AFDOriginInner>>(){

            public Page<AFDOriginInner> call(ServiceResponse<Page<AFDOriginInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByOriginGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AFDOriginInner>>, Observable<ServiceResponse<Page<AFDOriginInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginInner>>> call(ServiceResponse<Page<AFDOriginInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AFDOriginsInner.this.listByOriginGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByOriginGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDOriginInner>>>>(){

            public Observable<ServiceResponse<Page<AFDOriginInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AFDOriginsInner.this.listByOriginGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AFDOriginInner>> listByOriginGroupNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AFDOriginInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface AFDOriginsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins listByOriginGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins")
        public Observable<Response<ResponseBody>> listByOriginGroup(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Body AFDOriginInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Body AFDOriginInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Body AFDOriginUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Body AFDOriginUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="originGroupName") String var3, @Path(value="originName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins listByOriginGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByOriginGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

