/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.OriginGroupUpdateParameters;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.OriginGroupInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class OriginGroupsInner {
    private OriginGroupsService service;
    private CdnManagementClientImpl client;

    public OriginGroupsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (OriginGroupsService)retrofit.create(OriginGroupsService.class);
        this.client = client;
    }

    public PagedList<OriginGroupInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<OriginGroupInner>((Page)response.body()){

            public Page<OriginGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OriginGroupsInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OriginGroupInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, ListOperationCallback<OriginGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), (Func1)new Func1<String, Observable<ServiceResponse<Page<OriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<OriginGroupInner>>> call(String nextPageLink) {
                return OriginGroupsInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OriginGroupInner>> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Page<OriginGroupInner>>, Page<OriginGroupInner>>(){

            public Page<OriginGroupInner> call(ServiceResponse<Page<OriginGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).concatMap((Func1)new Func1<ServiceResponse<Page<OriginGroupInner>>, Observable<ServiceResponse<Page<OriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<OriginGroupInner>>> call(ServiceResponse<Page<OriginGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OriginGroupsInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<OriginGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OriginGroupsInner.this.listByEndpointDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OriginGroupInner>> listByEndpointDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OriginGroupInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public OriginGroupInner get(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return (OriginGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<OriginGroupInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName), serviceCallback);
    }

    public Observable<OriginGroupInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).map((Func1)new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>(){

            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return (OriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginGroupInner>>>(){

            public Observable<ServiceResponse<OriginGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OriginGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OriginGroupInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OriginGroupInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public OriginGroupInner create(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return (OriginGroupInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).toBlocking().last()).body());
    }

    public ServiceFuture<OriginGroupInner> createAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup), serviceCallback);
    }

    public Observable<OriginGroupInner> createAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).map((Func1)new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>(){

            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return (OriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginGroupInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroup == null) {
            throw new IllegalArgumentException("Parameter originGroup is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)originGroup));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroup, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OriginGroupInner>(){}.getType());
    }

    public OriginGroupInner beginCreate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return (OriginGroupInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).toBlocking().single()).body());
    }

    public ServiceFuture<OriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup), serviceCallback);
    }

    public Observable<OriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).map((Func1)new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>(){

            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return (OriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginGroupInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroup == null) {
            throw new IllegalArgumentException("Parameter originGroup is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)originGroup));
        return this.service.beginCreate(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroup, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginGroupInner>>>(){

            public Observable<ServiceResponse<OriginGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OriginGroupsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OriginGroupInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OriginGroupInner>(){}.getType()).register(201, new TypeToken<OriginGroupInner>(){}.getType()).register(202, new TypeToken<OriginGroupInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public OriginGroupInner update(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return (OriginGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<OriginGroupInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties), serviceCallback);
    }

    public Observable<OriginGroupInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).map((Func1)new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>(){

            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return (OriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroupUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originGroupUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroupUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OriginGroupInner>(){}.getType());
    }

    public OriginGroupInner beginUpdate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return (OriginGroupInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<OriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties), serviceCallback);
    }

    public Observable<OriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).map((Func1)new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>(){

            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return (OriginGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<OriginGroupInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroupUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)originGroupUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroupUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginGroupInner>>>(){

            public Observable<ServiceResponse<OriginGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OriginGroupsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OriginGroupInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OriginGroupInner>(){}.getType()).register(202, new TypeToken<OriginGroupInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = OriginGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<OriginGroupInner> listByEndpointNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OriginGroupInner>((Page)response.body()){

            public Page<OriginGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)OriginGroupsInner.this.listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OriginGroupInner>> listByEndpointNextAsync(String nextPageLink, ServiceFuture<List<OriginGroupInner>> serviceFuture, ListOperationCallback<OriginGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByEndpointNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<OriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<OriginGroupInner>>> call(String nextPageLink) {
                return OriginGroupsInner.this.listByEndpointNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OriginGroupInner>> listByEndpointNextAsync(String nextPageLink) {
        return this.listByEndpointNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<OriginGroupInner>>, Page<OriginGroupInner>>(){

            public Page<OriginGroupInner> call(ServiceResponse<Page<OriginGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByEndpointNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<OriginGroupInner>>, Observable<ServiceResponse<Page<OriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<OriginGroupInner>>> call(ServiceResponse<Page<OriginGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(OriginGroupsInner.this.listByEndpointNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OriginGroupInner>>>>(){

            public Observable<ServiceResponse<Page<OriginGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OriginGroupsInner.this.listByEndpointNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OriginGroupInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<OriginGroupInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface OriginGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups listByEndpoint"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups")
        public Observable<Response<ResponseBody>> listByEndpoint(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Body OriginGroupInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Body OriginGroupInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Body OriginGroupUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Body OriginGroupUpdateParameters var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="originGroupName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups listByEndpointNext"})
        @GET
        public Observable<Response<ResponseBody>> listByEndpointNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

