/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The JSON object that contains the properties to secure a domain.
 */
public class AFDDomainHttpsParameters {
    /**
     * Defines the source of the SSL certificate. Possible values include:
     * 'CustomerCertificate', 'ManagedCertificate'.
     */
    @JsonProperty(value = "certificateType", required = true)
    private AfdCertificateType certificateType;

    /**
     * TLS protocol version that will be used for Https. Possible values
     * include: 'TLS10', 'TLS12'.
     */
    @JsonProperty(value = "minimumTlsVersion")
    private AfdMinimumTlsVersion minimumTlsVersion;

    /**
     * Resource reference to the secret. ie. subs/rg/profile/secret.
     */
    @JsonProperty(value = "secret")
    private ResourceReference secret;

    /**
     * Get defines the source of the SSL certificate. Possible values include: 'CustomerCertificate', 'ManagedCertificate'.
     *
     * @return the certificateType value
     */
    public AfdCertificateType certificateType() {
        return this.certificateType;
    }

    /**
     * Set defines the source of the SSL certificate. Possible values include: 'CustomerCertificate', 'ManagedCertificate'.
     *
     * @param certificateType the certificateType value to set
     * @return the AFDDomainHttpsParameters object itself.
     */
    public AFDDomainHttpsParameters withCertificateType(AfdCertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    /**
     * Get tLS protocol version that will be used for Https. Possible values include: 'TLS10', 'TLS12'.
     *
     * @return the minimumTlsVersion value
     */
    public AfdMinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    /**
     * Set tLS protocol version that will be used for Https. Possible values include: 'TLS10', 'TLS12'.
     *
     * @param minimumTlsVersion the minimumTlsVersion value to set
     * @return the AFDDomainHttpsParameters object itself.
     */
    public AFDDomainHttpsParameters withMinimumTlsVersion(AfdMinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    /**
     * Get resource reference to the secret. ie. subs/rg/profile/secret.
     *
     * @return the secret value
     */
    public ResourceReference secret() {
        return this.secret;
    }

    /**
     * Set resource reference to the secret. ie. subs/rg/profile/secret.
     *
     * @param secret the secret value to set
     * @return the AFDDomainHttpsParameters object itself.
     */
    public AFDDomainHttpsParameters withSecret(ResourceReference secret) {
        this.secret = secret;
        return this;
    }

}
