/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Properties required to create or update an endpoint.
 */
@JsonFlatten
public class AFDEndpointUpdateParameters {
    /**
     * Endpoint tags.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     */
    @JsonProperty(value = "properties.originResponseTimeoutSeconds")
    private Integer originResponseTimeoutSeconds;

    /**
     * Whether to enable use of this rule. Permitted values are 'Enabled' or
     * 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.enabledState")
    private EnabledState enabledState;

    /**
     * Get endpoint tags.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set endpoint tags.
     *
     * @param tags the tags value to set
     * @return the AFDEndpointUpdateParameters object itself.
     */
    public AFDEndpointUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
     *
     * @return the originResponseTimeoutSeconds value
     */
    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    /**
     * Set send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
     *
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set
     * @return the AFDEndpointUpdateParameters object itself.
     */
    public AFDEndpointUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    /**
     * Get whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the enabledState value
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param enabledState the enabledState value to set
     * @return the AFDEndpointUpdateParameters object itself.
     */
    public AFDEndpointUpdateParameters withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

}
