/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * AFDOrigin properties needed for origin update.
 */
@JsonFlatten
public class AFDOriginUpdateParameters {
    /**
     * Resource reference to the Azure origin resource.
     */
    @JsonProperty(value = "properties.azureOrigin")
    private ResourceReference azureOrigin;

    /**
     * The address of the origin. Domain names, IPv4 addresses, and IPv6
     * addresses are supported.This should be unique across all origins in an
     * endpoint.
     */
    @JsonProperty(value = "properties.hostName")
    private String hostName;

    /**
     * The value of the HTTP port. Must be between 1 and 65535.
     */
    @JsonProperty(value = "properties.httpPort")
    private Integer httpPort;

    /**
     * The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JsonProperty(value = "properties.httpsPort")
    private Integer httpsPort;

    /**
     * The host header value sent to the origin with each request. If you leave
     * this blank, the request hostname determines this value. Azure CDN
     * origins, such as Web Apps, Blob Storage, and Cloud Services require this
     * host header value to match the origin hostname by default. This
     * overrides the host header defined at Endpoint.
     */
    @JsonProperty(value = "properties.originHostHeader")
    private String originHostHeader;

    /**
     * Priority of origin in given origin group for load balancing. Higher
     * priorities will not be used for load balancing if any lower priority
     * origin is healthy.Must be between 1 and 5.
     */
    @JsonProperty(value = "properties.priority")
    private Integer priority;

    /**
     * Weight of the origin in given origin group for load balancing. Must be
     * between 1 and 1000.
     */
    @JsonProperty(value = "properties.weight")
    private Integer weight;

    /**
     * The properties of the private link resource for private origin.
     */
    @JsonProperty(value = "properties.sharedPrivateLinkResource")
    private Object sharedPrivateLinkResource;

    /**
     * Whether to enable health probes to be made against backends defined
     * under backendPools. Health probes can only be disabled if there is a
     * single enabled backend in single enabled backend pool. Possible values
     * include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.enabledState")
    private EnabledState enabledState;

    /**
     * Get resource reference to the Azure origin resource.
     *
     * @return the azureOrigin value
     */
    public ResourceReference azureOrigin() {
        return this.azureOrigin;
    }

    /**
     * Set resource reference to the Azure origin resource.
     *
     * @param azureOrigin the azureOrigin value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withAzureOrigin(ResourceReference azureOrigin) {
        this.azureOrigin = azureOrigin;
        return this;
    }

    /**
     * Get the address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     *
     * @return the hostName value
     */
    public String hostName() {
        return this.hostName;
    }

    /**
     * Set the address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     *
     * @param hostName the hostName value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    /**
     * Get the value of the HTTP port. Must be between 1 and 65535.
     *
     * @return the httpPort value
     */
    public Integer httpPort() {
        return this.httpPort;
    }

    /**
     * Set the value of the HTTP port. Must be between 1 and 65535.
     *
     * @param httpPort the httpPort value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    /**
     * Get the value of the HTTPS port. Must be between 1 and 65535.
     *
     * @return the httpsPort value
     */
    public Integer httpsPort() {
        return this.httpsPort;
    }

    /**
     * Set the value of the HTTPS port. Must be between 1 and 65535.
     *
     * @param httpsPort the httpsPort value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    /**
     * Get the host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint.
     *
     * @return the originHostHeader value
     */
    public String originHostHeader() {
        return this.originHostHeader;
    }

    /**
     * Set the host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint.
     *
     * @param originHostHeader the originHostHeader value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    /**
     * Get priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
     *
     * @return the priority value
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
     *
     * @param priority the priority value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get weight of the origin in given origin group for load balancing. Must be between 1 and 1000.
     *
     * @return the weight value
     */
    public Integer weight() {
        return this.weight;
    }

    /**
     * Set weight of the origin in given origin group for load balancing. Must be between 1 and 1000.
     *
     * @param weight the weight value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the properties of the private link resource for private origin.
     *
     * @return the sharedPrivateLinkResource value
     */
    public Object sharedPrivateLinkResource() {
        return this.sharedPrivateLinkResource;
    }

    /**
     * Set the properties of the private link resource for private origin.
     *
     * @param sharedPrivateLinkResource the sharedPrivateLinkResource value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withSharedPrivateLinkResource(Object sharedPrivateLinkResource) {
        this.sharedPrivateLinkResource = sharedPrivateLinkResource;
        return this;
    }

    /**
     * Get whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the enabledState value
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param enabledState the enabledState value to set
     * @return the AFDOriginUpdateParameters object itself.
     */
    public AFDOriginUpdateParameters withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

}
