/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The tracking states for afd resources.
 */
public class AFDStateProperties {
    /**
     * Provisioning status. Possible values include: 'Succeeded', 'Failed',
     * 'Updating', 'Deleting', 'Creating'.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;

    /**
     * Possible values include: 'NotStarted', 'InProgress', 'Succeeded',
     * 'Failed'.
     */
    @JsonProperty(value = "deploymentStatus", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;

    /**
     * Get provisioning status. Possible values include: 'Succeeded', 'Failed', 'Updating', 'Deleting', 'Creating'.
     *
     * @return the provisioningState value
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get possible values include: 'NotStarted', 'InProgress', 'Succeeded', 'Failed'.
     *
     * @return the deploymentStatus value
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

}
