/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Round-Robin load balancing settings for a backend pool.
 */
public class LoadBalancingSettingsParameters {
    /**
     * The number of samples to consider for load balancing decisions.
     */
    @JsonProperty(value = "sampleSize")
    private Integer sampleSize;

    /**
     * The number of samples within the sample period that must succeed.
     */
    @JsonProperty(value = "successfulSamplesRequired")
    private Integer successfulSamplesRequired;

    /**
     * The additional latency in milliseconds for probes to fall into the
     * lowest latency bucket.
     */
    @JsonProperty(value = "additionalLatencyInMilliseconds")
    private Integer additionalLatencyInMilliseconds;

    /**
     * Get the number of samples to consider for load balancing decisions.
     *
     * @return the sampleSize value
     */
    public Integer sampleSize() {
        return this.sampleSize;
    }

    /**
     * Set the number of samples to consider for load balancing decisions.
     *
     * @param sampleSize the sampleSize value to set
     * @return the LoadBalancingSettingsParameters object itself.
     */
    public LoadBalancingSettingsParameters withSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
        return this;
    }

    /**
     * Get the number of samples within the sample period that must succeed.
     *
     * @return the successfulSamplesRequired value
     */
    public Integer successfulSamplesRequired() {
        return this.successfulSamplesRequired;
    }

    /**
     * Set the number of samples within the sample period that must succeed.
     *
     * @param successfulSamplesRequired the successfulSamplesRequired value to set
     * @return the LoadBalancingSettingsParameters object itself.
     */
    public LoadBalancingSettingsParameters withSuccessfulSamplesRequired(Integer successfulSamplesRequired) {
        this.successfulSamplesRequired = successfulSamplesRequired;
        return this;
    }

    /**
     * Get the additional latency in milliseconds for probes to fall into the lowest latency bucket.
     *
     * @return the additionalLatencyInMilliseconds value
     */
    public Integer additionalLatencyInMilliseconds() {
        return this.additionalLatencyInMilliseconds;
    }

    /**
     * Set the additional latency in milliseconds for probes to fall into the lowest latency bucket.
     *
     * @param additionalLatencyInMilliseconds the additionalLatencyInMilliseconds value to set
     * @return the LoadBalancingSettingsParameters object itself.
     */
    public LoadBalancingSettingsParameters withAdditionalLatencyInMilliseconds(Integer additionalLatencyInMilliseconds) {
        this.additionalLatencyInMilliseconds = additionalLatencyInMilliseconds;
        return this;
    }

}
