/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines contents of a web application firewall global configuration.
 */
public class PolicySettings {
    /**
     * describes if the policy is in enabled state or disabled state. Possible
     * values include: 'Disabled', 'Enabled'.
     */
    @JsonProperty(value = "enabledState")
    private PolicyEnabledState enabledState;

    /**
     * Describes if it is in detection mode or prevention mode at policy level.
     * Possible values include: 'Prevention', 'Detection'.
     */
    @JsonProperty(value = "mode")
    private PolicyMode mode;

    /**
     * If action type is redirect, this field represents the default redirect
     * URL for the client.
     */
    @JsonProperty(value = "defaultRedirectUrl")
    private String defaultRedirectUrl;

    /**
     * If the action type is block, this field defines the default customer
     * overridable http response status code.
     */
    @JsonProperty(value = "defaultCustomBlockResponseStatusCode")
    private Integer defaultCustomBlockResponseStatusCode;

    /**
     * If the action type is block, customer can override the response body.
     * The body must be specified in base64 encoding.
     */
    @JsonProperty(value = "defaultCustomBlockResponseBody")
    private String defaultCustomBlockResponseBody;

    /**
     * Get describes if the policy is in enabled state or disabled state. Possible values include: 'Disabled', 'Enabled'.
     *
     * @return the enabledState value
     */
    public PolicyEnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set describes if the policy is in enabled state or disabled state. Possible values include: 'Disabled', 'Enabled'.
     *
     * @param enabledState the enabledState value to set
     * @return the PolicySettings object itself.
     */
    public PolicySettings withEnabledState(PolicyEnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Get describes if it is in detection mode or prevention mode at policy level. Possible values include: 'Prevention', 'Detection'.
     *
     * @return the mode value
     */
    public PolicyMode mode() {
        return this.mode;
    }

    /**
     * Set describes if it is in detection mode or prevention mode at policy level. Possible values include: 'Prevention', 'Detection'.
     *
     * @param mode the mode value to set
     * @return the PolicySettings object itself.
     */
    public PolicySettings withMode(PolicyMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get if action type is redirect, this field represents the default redirect URL for the client.
     *
     * @return the defaultRedirectUrl value
     */
    public String defaultRedirectUrl() {
        return this.defaultRedirectUrl;
    }

    /**
     * Set if action type is redirect, this field represents the default redirect URL for the client.
     *
     * @param defaultRedirectUrl the defaultRedirectUrl value to set
     * @return the PolicySettings object itself.
     */
    public PolicySettings withDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
        return this;
    }

    /**
     * Get if the action type is block, this field defines the default customer overridable http response status code.
     *
     * @return the defaultCustomBlockResponseStatusCode value
     */
    public Integer defaultCustomBlockResponseStatusCode() {
        return this.defaultCustomBlockResponseStatusCode;
    }

    /**
     * Set if the action type is block, this field defines the default customer overridable http response status code.
     *
     * @param defaultCustomBlockResponseStatusCode the defaultCustomBlockResponseStatusCode value to set
     * @return the PolicySettings object itself.
     */
    public PolicySettings withDefaultCustomBlockResponseStatusCode(Integer defaultCustomBlockResponseStatusCode) {
        this.defaultCustomBlockResponseStatusCode = defaultCustomBlockResponseStatusCode;
        return this;
    }

    /**
     * Get if the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     *
     * @return the defaultCustomBlockResponseBody value
     */
    public String defaultCustomBlockResponseBody() {
        return this.defaultCustomBlockResponseBody;
    }

    /**
     * Set if the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     *
     * @param defaultCustomBlockResponseBody the defaultCustomBlockResponseBody value to set
     * @return the PolicySettings object itself.
     */
    public PolicySettings withDefaultCustomBlockResponseBody(String defaultCustomBlockResponseBody) {
        this.defaultCustomBlockResponseBody = defaultCustomBlockResponseBody;
        return this;
    }

}
