/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the properties of an existing Shared Private Link Resource to use
 * when connecting to a private origin.
 */
public class SharedPrivateLinkResourceProperties {
    /**
     * The resource id of the resource the shared private link resource is for.
     */
    @JsonProperty(value = "privateLink")
    private ResourceReference privateLink;

    /**
     * The location of the shared private link resource.
     */
    @JsonProperty(value = "privateLinkLocation")
    private String privateLinkLocation;

    /**
     * The group id from the provider of resource the shared private link
     * resource is for.
     */
    @JsonProperty(value = "groupId")
    private String groupId;

    /**
     * The request message for requesting approval of the shared private link
     * resource.
     */
    @JsonProperty(value = "requestMessage")
    private String requestMessage;

    /**
     * Status of the shared private link resource. Can be Pending, Approved,
     * Rejected, Disconnected, or Timeout. Possible values include: 'Pending',
     * 'Approved', 'Rejected', 'Disconnected', 'Timeout'.
     */
    @JsonProperty(value = "status")
    private SharedPrivateLinkResourceStatus status;

    /**
     * Get the resource id of the resource the shared private link resource is for.
     *
     * @return the privateLink value
     */
    public ResourceReference privateLink() {
        return this.privateLink;
    }

    /**
     * Set the resource id of the resource the shared private link resource is for.
     *
     * @param privateLink the privateLink value to set
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withPrivateLink(ResourceReference privateLink) {
        this.privateLink = privateLink;
        return this;
    }

    /**
     * Get the location of the shared private link resource.
     *
     * @return the privateLinkLocation value
     */
    public String privateLinkLocation() {
        return this.privateLinkLocation;
    }

    /**
     * Set the location of the shared private link resource.
     *
     * @param privateLinkLocation the privateLinkLocation value to set
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withPrivateLinkLocation(String privateLinkLocation) {
        this.privateLinkLocation = privateLinkLocation;
        return this;
    }

    /**
     * Get the group id from the provider of resource the shared private link resource is for.
     *
     * @return the groupId value
     */
    public String groupId() {
        return this.groupId;
    }

    /**
     * Set the group id from the provider of resource the shared private link resource is for.
     *
     * @param groupId the groupId value to set
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
     * Get the request message for requesting approval of the shared private link resource.
     *
     * @return the requestMessage value
     */
    public String requestMessage() {
        return this.requestMessage;
    }

    /**
     * Set the request message for requesting approval of the shared private link resource.
     *
     * @param requestMessage the requestMessage value to set
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    /**
     * Get status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected', 'Timeout'.
     *
     * @return the status value
     */
    public SharedPrivateLinkResourceStatus status() {
        return this.status;
    }

    /**
     * Set status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected', 'Timeout'.
     *
     * @param status the status value to set
     * @return the SharedPrivateLinkResourceProperties object itself.
     */
    public SharedPrivateLinkResourceProperties withStatus(SharedPrivateLinkResourceStatus status) {
        this.status = status;
        return this;
    }

}
