/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Input of the secret to be validated.
 */
public class ValidateSecretInput {
    /**
     * The secret source.
     */
    @JsonProperty(value = "secretSource", required = true)
    private ResourceReference secretSource;

    /**
     * The secret type. Possible values include: 'UrlSigningKey',
     * 'ManagedCertificate', 'CustomerCertificate'.
     */
    @JsonProperty(value = "secretType", required = true)
    private ValidateSecretType secretType;

    /**
     * Get the secret source.
     *
     * @return the secretSource value
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set the secret source.
     *
     * @param secretSource the secretSource value to set
     * @return the ValidateSecretInput object itself.
     */
    public ValidateSecretInput withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get the secret type. Possible values include: 'UrlSigningKey', 'ManagedCertificate', 'CustomerCertificate'.
     *
     * @return the secretType value
     */
    public ValidateSecretType secretType() {
        return this.secretType;
    }

    /**
     * Set the secret type. Possible values include: 'UrlSigningKey', 'ManagedCertificate', 'CustomerCertificate'.
     *
     * @param secretType the secretType value to set
     * @return the ValidateSecretInput object itself.
     */
    public ValidateSecretInput withSecretType(ValidateSecretType secretType) {
        this.secretType = secretType;
        return this;
    }

}
