/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.management.cdn.LoadBalancingSettingsParameters;
import com.microsoft.azure.management.cdn.HealthProbeParameters;
import com.microsoft.azure.management.cdn.ResponseBasedOriginErrorDetectionParameters;
import com.microsoft.azure.management.cdn.EnabledState;
import com.microsoft.azure.management.cdn.AfdProvisioningState;
import com.microsoft.azure.management.cdn.DeploymentStatus;
import com.microsoft.azure.management.cdn.SystemData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * AFDOrigin group comprising of origins is used for load balancing to origins
 * when the content cannot be served from CDN.
 */
@JsonFlatten
public class AFDOriginGroupInner extends ProxyResource {
    /**
     * Load balancing settings for a backend pool.
     */
    @JsonProperty(value = "properties.loadBalancingSettings")
    private LoadBalancingSettingsParameters loadBalancingSettings;

    /**
     * Health probe settings to the origin that is used to determine the health
     * of the origin.
     */
    @JsonProperty(value = "properties.healthProbeSettings")
    private HealthProbeParameters healthProbeSettings;

    /**
     * Time in minutes to shift the traffic to the endpoint gradually when an
     * unhealthy endpoint comes healthy or a new endpoint is added. Default is
     * 10 mins. This property is currently not supported.
     */
    @JsonProperty(value = "properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;

    /**
     * The JSON object that contains the properties to determine origin health
     * using real requests/responses. This property is currently not supported.
     */
    @JsonProperty(value = "properties.responseBasedAfdOriginErrorDetectionSettings")
    private ResponseBasedOriginErrorDetectionParameters responseBasedAfdOriginErrorDetectionSettings;

    /**
     * Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.sessionAffinityState")
    private EnabledState sessionAffinityState;

    /**
     * Provisioning status. Possible values include: 'Succeeded', 'Failed',
     * 'Updating', 'Deleting', 'Creating'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;

    /**
     * Possible values include: 'NotStarted', 'InProgress', 'Succeeded',
     * 'Failed'.
     */
    @JsonProperty(value = "properties.deploymentStatus", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;

    /**
     * The systemData property.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get load balancing settings for a backend pool.
     *
     * @return the loadBalancingSettings value
     */
    public LoadBalancingSettingsParameters loadBalancingSettings() {
        return this.loadBalancingSettings;
    }

    /**
     * Set load balancing settings for a backend pool.
     *
     * @param loadBalancingSettings the loadBalancingSettings value to set
     * @return the AFDOriginGroupInner object itself.
     */
    public AFDOriginGroupInner withLoadBalancingSettings(LoadBalancingSettingsParameters loadBalancingSettings) {
        this.loadBalancingSettings = loadBalancingSettings;
        return this;
    }

    /**
     * Get health probe settings to the origin that is used to determine the health of the origin.
     *
     * @return the healthProbeSettings value
     */
    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    /**
     * Set health probe settings to the origin that is used to determine the health of the origin.
     *
     * @param healthProbeSettings the healthProbeSettings value to set
     * @return the AFDOriginGroupInner object itself.
     */
    public AFDOriginGroupInner withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    /**
     * Get time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     *
     * @return the trafficRestorationTimeToHealedOrNewEndpointsInMinutes value
     */
    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    /**
     * Set time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
     *
     * @param trafficRestorationTimeToHealedOrNewEndpointsInMinutes the trafficRestorationTimeToHealedOrNewEndpointsInMinutes value to set
     * @return the AFDOriginGroupInner object itself.
     */
    public AFDOriginGroupInner withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    /**
     * Get the JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
     *
     * @return the responseBasedAfdOriginErrorDetectionSettings value
     */
    public ResponseBasedOriginErrorDetectionParameters responseBasedAfdOriginErrorDetectionSettings() {
        return this.responseBasedAfdOriginErrorDetectionSettings;
    }

    /**
     * Set the JSON object that contains the properties to determine origin health using real requests/responses. This property is currently not supported.
     *
     * @param responseBasedAfdOriginErrorDetectionSettings the responseBasedAfdOriginErrorDetectionSettings value to set
     * @return the AFDOriginGroupInner object itself.
     */
    public AFDOriginGroupInner withResponseBasedAfdOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedAfdOriginErrorDetectionSettings) {
        this.responseBasedAfdOriginErrorDetectionSettings = responseBasedAfdOriginErrorDetectionSettings;
        return this;
    }

    /**
     * Get whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the sessionAffinityState value
     */
    public EnabledState sessionAffinityState() {
        return this.sessionAffinityState;
    }

    /**
     * Set whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param sessionAffinityState the sessionAffinityState value to set
     * @return the AFDOriginGroupInner object itself.
     */
    public AFDOriginGroupInner withSessionAffinityState(EnabledState sessionAffinityState) {
        this.sessionAffinityState = sessionAffinityState;
        return this;
    }

    /**
     * Get provisioning status. Possible values include: 'Succeeded', 'Failed', 'Updating', 'Deleting', 'Creating'.
     *
     * @return the provisioningState value
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get possible values include: 'NotStarted', 'InProgress', 'Succeeded', 'Failed'.
     *
     * @return the deploymentStatus value
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the systemData value.
     *
     * @return the systemData value
     */
    public SystemData systemData() {
        return this.systemData;
    }

}
