/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.CustomDomainHttpsParameters;
import com.microsoft.azure.management.cdn.CustomDomainParameters;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in CustomDomains.
 */
public class CustomDomainsInner {
    /** The Retrofit service to perform REST calls. */
    private CustomDomainsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of CustomDomainsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public CustomDomainsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(CustomDomainsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for CustomDomains to be
     * used by Retrofit to perform actually REST calls.
     */
    interface CustomDomainsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains listByEndpoint" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains")
        Observable<Response<ResponseBody>> listByEndpoint(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CustomDomainParameters customDomainProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CustomDomainParameters customDomainProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains disableCustomHttps" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/disableCustomHttps")
        Observable<Response<ResponseBody>> disableCustomHttps(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains enableCustomHttps" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/enableCustomHttps")
        Observable<Response<ResponseBody>> enableCustomHttps(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("customDomainName") String customDomainName, @Path("subscriptionId") String subscriptionId, @Body CustomDomainHttpsParameters customDomainHttpsParameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CustomDomains listByEndpointNext" })
        @GET
        Observable<Response<ResponseBody>> listByEndpointNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CustomDomainInner&gt; object if successful.
     */
    public PagedList<CustomDomainInner> listByEndpoint(final String resourceGroupName, final String profileName, final String endpointName) {
        ServiceResponse<Page<CustomDomainInner>> response = listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<CustomDomainInner>(response.body()) {
            @Override
            public Page<CustomDomainInner> nextPage(String nextPageLink) {
                return listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CustomDomainInner>> listByEndpointAsync(final String resourceGroupName, final String profileName, final String endpointName, final ListOperationCallback<CustomDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName),
            new Func1<String, Observable<ServiceResponse<Page<CustomDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CustomDomainInner>>> call(String nextPageLink) {
                    return listByEndpointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CustomDomainInner&gt; object
     */
    public Observable<Page<CustomDomainInner>> listByEndpointAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName)
            .map(new Func1<ServiceResponse<Page<CustomDomainInner>>, Page<CustomDomainInner>>() {
                @Override
                public Page<CustomDomainInner> call(ServiceResponse<Page<CustomDomainInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CustomDomainInner&gt; object
     */
    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName)
            .concatMap(new Func1<ServiceResponse<Page<CustomDomainInner>>, Observable<ServiceResponse<Page<CustomDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CustomDomainInner>>> call(ServiceResponse<Page<CustomDomainInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEndpointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
    ServiceResponse<PageImpl<CustomDomainInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<CustomDomainInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<CustomDomainInner>> * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CustomDomainInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointSinglePageAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CustomDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CustomDomainInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CustomDomainInner>> result = listByEndpointDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CustomDomainInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CustomDomainInner>> listByEndpointDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CustomDomainInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CustomDomainInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner get(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single().body();
    }

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> getAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<CustomDomainInner> getAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<ServiceResponse<CustomDomainInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomDomainInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CustomDomainInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CustomDomainInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CustomDomainInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner create(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).toBlocking().last().body();
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> createAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName), serviceCallback);
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CustomDomainInner> createAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CustomDomainInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        CustomDomainParameters customDomainProperties = new CustomDomainParameters();
        customDomainProperties.withHostName(hostName);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CustomDomainInner>() { }.getType());
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner beginCreate(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).toBlocking().single().body();
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName), serviceCallback);
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<CustomDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, hostName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<ServiceResponse<CustomDomainInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        CustomDomainParameters customDomainProperties = new CustomDomainParameters();
        customDomainProperties.withHostName(hostName);
        return service.beginCreate(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomDomainInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CustomDomainInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CustomDomainInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CustomDomainInner>() { }.getType())
                .register(201, new TypeToken<CustomDomainInner>() { }.getType())
                .register(202, new TypeToken<CustomDomainInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner delete(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().last().body();
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> deleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CustomDomainInner> deleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CustomDomainInner>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<CustomDomainInner>() { }.getType());
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner beginDelete(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single().body();
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<CustomDomainInner> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing custom domain within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<ServiceResponse<CustomDomainInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomDomainInner> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CustomDomainInner> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CustomDomainInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<CustomDomainInner>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner disableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return disableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single().body();
    }

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> disableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(disableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<CustomDomainInner> disableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return disableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Disable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<ServiceResponse<CustomDomainInner>> disableCustomHttpsWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.disableCustomHttps(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomDomainInner> clientResponse = disableCustomHttpsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CustomDomainInner> disableCustomHttpsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CustomDomainInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<CustomDomainInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner enableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).toBlocking().single().body();
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName), serviceCallback);
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        return enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<ServiceResponse<CustomDomainInner>> enableCustomHttpsWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final CustomDomainHttpsParameters customDomainHttpsParameters = null;
        return service.enableCustomHttps(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), customDomainHttpsParameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomDomainInner> clientResponse = enableCustomHttpsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The configuration specifying how to enable HTTPS for the custom domain - using CDN managed certificate or user's own certificate. If not specified, enabling ssl uses CDN managed certificate by default.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomDomainInner object if successful.
     */
    public CustomDomainInner enableCustomHttps(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters) {
        return enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters).toBlocking().single().body();
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The configuration specifying how to enable HTTPS for the custom domain - using CDN managed certificate or user's own certificate. If not specified, enabling ssl uses CDN managed certificate by default.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters, final ServiceCallback<CustomDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters), serviceCallback);
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The configuration specifying how to enable HTTPS for the custom domain - using CDN managed certificate or user's own certificate. If not specified, enabling ssl uses CDN managed certificate by default.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<CustomDomainInner> enableCustomHttpsAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters) {
        return enableCustomHttpsWithServiceResponseAsync(resourceGroupName, profileName, endpointName, customDomainName, customDomainHttpsParameters).map(new Func1<ServiceResponse<CustomDomainInner>, CustomDomainInner>() {
            @Override
            public CustomDomainInner call(ServiceResponse<CustomDomainInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Enable https delivery of the custom domain.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param customDomainName Name of the custom domain within an endpoint.
     * @param customDomainHttpsParameters The configuration specifying how to enable HTTPS for the custom domain - using CDN managed certificate or user's own certificate. If not specified, enabling ssl uses CDN managed certificate by default.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomDomainInner object
     */
    public Observable<ServiceResponse<CustomDomainInner>> enableCustomHttpsWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String customDomainName, CustomDomainHttpsParameters customDomainHttpsParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (customDomainName == null) {
            throw new IllegalArgumentException("Parameter customDomainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(customDomainHttpsParameters);
        return service.enableCustomHttps(resourceGroupName, profileName, endpointName, customDomainName, this.client.subscriptionId(), customDomainHttpsParameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomDomainInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomDomainInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomDomainInner> clientResponse = enableCustomHttpsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CustomDomainInner> enableCustomHttpsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CustomDomainInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<CustomDomainInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CustomDomainInner&gt; object if successful.
     */
    public PagedList<CustomDomainInner> listByEndpointNext(final String nextPageLink) {
        ServiceResponse<Page<CustomDomainInner>> response = listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CustomDomainInner>(response.body()) {
            @Override
            public Page<CustomDomainInner> nextPage(String nextPageLink) {
                return listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CustomDomainInner>> listByEndpointNextAsync(final String nextPageLink, final ServiceFuture<List<CustomDomainInner>> serviceFuture, final ListOperationCallback<CustomDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEndpointNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<CustomDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CustomDomainInner>>> call(String nextPageLink) {
                    return listByEndpointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CustomDomainInner&gt; object
     */
    public Observable<Page<CustomDomainInner>> listByEndpointNextAsync(final String nextPageLink) {
        return listByEndpointNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<CustomDomainInner>>, Page<CustomDomainInner>>() {
                @Override
                public Page<CustomDomainInner> call(ServiceResponse<Page<CustomDomainInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CustomDomainInner&gt; object
     */
    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointNextWithServiceResponseAsync(final String nextPageLink) {
        return listByEndpointNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<CustomDomainInner>>, Observable<ServiceResponse<Page<CustomDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CustomDomainInner>>> call(ServiceResponse<Page<CustomDomainInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEndpointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing custom domains within an endpoint.
     *
    ServiceResponse<PageImpl<CustomDomainInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CustomDomainInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CustomDomainInner>>> listByEndpointNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CustomDomainInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CustomDomainInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CustomDomainInner>> result = listByEndpointNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CustomDomainInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CustomDomainInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CustomDomainInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CustomDomainInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
