/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.LogMetric;
import com.microsoft.azure.management.cdn.LogMetricsGranularity;
import com.microsoft.azure.management.cdn.LogMetricsGroupBy;
import com.microsoft.azure.management.cdn.LogRanking;
import com.microsoft.azure.management.cdn.LogRankingMetric;
import com.microsoft.azure.management.cdn.WafAction;
import com.microsoft.azure.management.cdn.WafGranularity;
import com.microsoft.azure.management.cdn.WafMetric;
import com.microsoft.azure.management.cdn.WafRankingGroupBy;
import com.microsoft.azure.management.cdn.WafRankingType;
import com.microsoft.azure.management.cdn.WafRuleType;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in LogAnalytics.
 */
public class LogAnalyticsInner {
    /** The Retrofit service to perform REST calls. */
    private LogAnalyticsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of LogAnalyticsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public LogAnalyticsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(LogAnalyticsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for LogAnalytics to be
     * used by Retrofit to perform actually REST calls.
     */
    interface LogAnalyticsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics")
        Observable<Response<ResponseBody>> getLogAnalyticsMetrics(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Query("api-version") String apiVersion, @Query("metrics") String metrics, @Query("dateTimeBegin") DateTime dateTimeBegin, @Query("dateTimeEnd") DateTime dateTimeEnd, @Query("granularity") LogMetricsGranularity granularity, @Query("groupBy") String groupBy, @Query("continents") String continents, @Query("countryOrRegions") String countryOrRegions, @Query("customDomains") String customDomains, @Query("protocols") String protocols, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsRankings" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings")
        Observable<Response<ResponseBody>> getLogAnalyticsRankings(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Query("api-version") String apiVersion, @Query("rankings") String rankings, @Query("metrics") String metrics, @Query("maxRanking") int maxRanking, @Query("dateTimeBegin") DateTime dateTimeBegin, @Query("dateTimeEnd") DateTime dateTimeEnd, @Query("customDomains") String customDomains, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsLocations" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations")
        Observable<Response<ResponseBody>> getLogAnalyticsLocations(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getLogAnalyticsResources" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources")
        Observable<Response<ResponseBody>> getLogAnalyticsResources(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getWafLogAnalyticsMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics")
        Observable<Response<ResponseBody>> getWafLogAnalyticsMetrics(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Query("api-version") String apiVersion, @Query("metrics") String metrics, @Query("dateTimeBegin") DateTime dateTimeBegin, @Query("dateTimeEnd") DateTime dateTimeEnd, @Query("granularity") WafGranularity granularity, @Query("actions") String actions, @Query("groupBy") String groupBy, @Query("ruleTypes") String ruleTypes, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.LogAnalytics getWafLogAnalyticsRankings" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings")
        Observable<Response<ResponseBody>> getWafLogAnalyticsRankings(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Query("api-version") String apiVersion, @Query("metrics") String metrics, @Query("dateTimeBegin") DateTime dateTimeBegin, @Query("dateTimeEnd") DateTime dateTimeEnd, @Query("maxRanking") int maxRanking, @Query("rankings") String rankings, @Query("actions") String actions, @Query("ruleTypes") String ruleTypes, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MetricsResponseInner object if successful.
     */
    public MetricsResponseInner getLogAnalyticsMetrics(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        return getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols).toBlocking().single().body();
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, final ServiceCallback<MetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols), serviceCallback);
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MetricsResponseInner object
     */
    public Observable<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        return getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols).map(new Func1<ServiceResponse<MetricsResponseInner>, MetricsResponseInner>() {
            @Override
            public MetricsResponseInner call(ServiceResponse<MetricsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MetricsResponseInner object
     */
    public Observable<ServiceResponse<MetricsResponseInner>> getLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        if (customDomains == null) {
            throw new IllegalArgumentException("Parameter customDomains is required and cannot be null.");
        }
        if (protocols == null) {
            throw new IllegalArgumentException("Parameter protocols is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(customDomains);
        Validator.validate(protocols);
        final List<LogMetricsGroupBy> groupBy = null;
        final List<String> continents = null;
        final List<String> countryOrRegions = null;
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String continentsConverted = this.client.serializerAdapter().serializeList(continents, CollectionFormat.MULTI);
        String countryOrRegionsConverted = this.client.serializerAdapter().serializeList(countryOrRegions, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        String protocolsConverted = this.client.serializerAdapter().serializeList(protocols, CollectionFormat.MULTI);
        return service.getLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, groupByConverted, continentsConverted, countryOrRegionsConverted, customDomainsConverted, protocolsConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<MetricsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MetricsResponseInner> clientResponse = getLogAnalyticsMetricsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @param groupBy the List&lt;LogMetricsGroupBy&gt; value
     * @param continents the List&lt;String&gt; value
     * @param countryOrRegions the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MetricsResponseInner object if successful.
     */
    public MetricsResponseInner getLogAnalyticsMetrics(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        return getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).toBlocking().single().body();
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @param groupBy the List&lt;LogMetricsGroupBy&gt; value
     * @param continents the List&lt;String&gt; value
     * @param countryOrRegions the List&lt;String&gt; value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions, final ServiceCallback<MetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions), serviceCallback);
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @param groupBy the List&lt;LogMetricsGroupBy&gt; value
     * @param continents the List&lt;String&gt; value
     * @param countryOrRegions the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MetricsResponseInner object
     */
    public Observable<MetricsResponseInner> getLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        return getLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions).map(new Func1<ServiceResponse<MetricsResponseInner>, MetricsResponseInner>() {
            @Override
            public MetricsResponseInner call(ServiceResponse<MetricsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get log report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;LogMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param customDomains the List&lt;String&gt; value
     * @param protocols the List&lt;String&gt; value
     * @param groupBy the List&lt;LogMetricsGroupBy&gt; value
     * @param continents the List&lt;String&gt; value
     * @param countryOrRegions the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MetricsResponseInner object
     */
    public Observable<ServiceResponse<MetricsResponseInner>> getLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, LogMetricsGranularity granularity, List<String> customDomains, List<String> protocols, List<LogMetricsGroupBy> groupBy, List<String> continents, List<String> countryOrRegions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        if (customDomains == null) {
            throw new IllegalArgumentException("Parameter customDomains is required and cannot be null.");
        }
        if (protocols == null) {
            throw new IllegalArgumentException("Parameter protocols is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(groupBy);
        Validator.validate(continents);
        Validator.validate(countryOrRegions);
        Validator.validate(customDomains);
        Validator.validate(protocols);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String continentsConverted = this.client.serializerAdapter().serializeList(continents, CollectionFormat.MULTI);
        String countryOrRegionsConverted = this.client.serializerAdapter().serializeList(countryOrRegions, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        String protocolsConverted = this.client.serializerAdapter().serializeList(protocols, CollectionFormat.MULTI);
        return service.getLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, groupByConverted, continentsConverted, countryOrRegionsConverted, customDomainsConverted, protocolsConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<MetricsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MetricsResponseInner> clientResponse = getLogAnalyticsMetricsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MetricsResponseInner> getLogAnalyticsMetricsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MetricsResponseInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MetricsResponseInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RankingsResponseInner object if successful.
     */
    public RankingsResponseInner getLogAnalyticsRankings(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd) {
        return getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd).toBlocking().single().body();
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, final ServiceCallback<RankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd), serviceCallback);
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RankingsResponseInner object
     */
    public Observable<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd) {
        return getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd).map(new Func1<ServiceResponse<RankingsResponseInner>, RankingsResponseInner>() {
            @Override
            public RankingsResponseInner call(ServiceResponse<RankingsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RankingsResponseInner object
     */
    public Observable<ServiceResponse<RankingsResponseInner>> getLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        Validator.validate(rankings);
        Validator.validate(metrics);
        final List<String> customDomains = null;
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        return service.getLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), rankingsConverted, metricsConverted, maxRanking, dateTimeBegin, dateTimeEnd, customDomainsConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RankingsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<RankingsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RankingsResponseInner> clientResponse = getLogAnalyticsRankingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param customDomains the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RankingsResponseInner object if successful.
     */
    public RankingsResponseInner getLogAnalyticsRankings(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains) {
        return getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).toBlocking().single().body();
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param customDomains the List&lt;String&gt; value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains, final ServiceCallback<RankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains), serviceCallback);
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param customDomains the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RankingsResponseInner object
     */
    public Observable<RankingsResponseInner> getLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains) {
        return getLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains).map(new Func1<ServiceResponse<RankingsResponseInner>, RankingsResponseInner>() {
            @Override
            public RankingsResponseInner call(ServiceResponse<RankingsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get log analytics ranking report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param rankings the List&lt;LogRanking&gt; value
     * @param metrics the List&lt;LogRankingMetric&gt; value
     * @param maxRanking the int value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param customDomains the List&lt;String&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RankingsResponseInner object
     */
    public Observable<ServiceResponse<RankingsResponseInner>> getLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<LogRanking> rankings, List<LogRankingMetric> metrics, int maxRanking, DateTime dateTimeBegin, DateTime dateTimeEnd, List<String> customDomains) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        Validator.validate(rankings);
        Validator.validate(metrics);
        Validator.validate(customDomains);
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String customDomainsConverted = this.client.serializerAdapter().serializeList(customDomains, CollectionFormat.MULTI);
        return service.getLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), rankingsConverted, metricsConverted, maxRanking, dateTimeBegin, dateTimeEnd, customDomainsConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RankingsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<RankingsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RankingsResponseInner> clientResponse = getLogAnalyticsRankingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RankingsResponseInner> getLogAnalyticsRankingsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RankingsResponseInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RankingsResponseInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all available location names for AFD log analytics report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ContinentsResponseInner object if successful.
     */
    public ContinentsResponseInner getLogAnalyticsLocations(String resourceGroupName, String profileName) {
        return getLogAnalyticsLocationsWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single().body();
    }

    /**
     * Get all available location names for AFD log analytics report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ContinentsResponseInner> getLogAnalyticsLocationsAsync(String resourceGroupName, String profileName, final ServiceCallback<ContinentsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogAnalyticsLocationsWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    /**
     * Get all available location names for AFD log analytics report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ContinentsResponseInner object
     */
    public Observable<ContinentsResponseInner> getLogAnalyticsLocationsAsync(String resourceGroupName, String profileName) {
        return getLogAnalyticsLocationsWithServiceResponseAsync(resourceGroupName, profileName).map(new Func1<ServiceResponse<ContinentsResponseInner>, ContinentsResponseInner>() {
            @Override
            public ContinentsResponseInner call(ServiceResponse<ContinentsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get all available location names for AFD log analytics report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ContinentsResponseInner object
     */
    public Observable<ServiceResponse<ContinentsResponseInner>> getLogAnalyticsLocationsWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getLogAnalyticsLocations(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContinentsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<ContinentsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ContinentsResponseInner> clientResponse = getLogAnalyticsLocationsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ContinentsResponseInner> getLogAnalyticsLocationsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ContinentsResponseInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ContinentsResponseInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all endpoints and custom domains available for AFD log report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourcesResponseInner object if successful.
     */
    public ResourcesResponseInner getLogAnalyticsResources(String resourceGroupName, String profileName) {
        return getLogAnalyticsResourcesWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single().body();
    }

    /**
     * Get all endpoints and custom domains available for AFD log report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourcesResponseInner> getLogAnalyticsResourcesAsync(String resourceGroupName, String profileName, final ServiceCallback<ResourcesResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getLogAnalyticsResourcesWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    /**
     * Get all endpoints and custom domains available for AFD log report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourcesResponseInner object
     */
    public Observable<ResourcesResponseInner> getLogAnalyticsResourcesAsync(String resourceGroupName, String profileName) {
        return getLogAnalyticsResourcesWithServiceResponseAsync(resourceGroupName, profileName).map(new Func1<ServiceResponse<ResourcesResponseInner>, ResourcesResponseInner>() {
            @Override
            public ResourcesResponseInner call(ServiceResponse<ResourcesResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get all endpoints and custom domains available for AFD log report.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourcesResponseInner object
     */
    public Observable<ServiceResponse<ResourcesResponseInner>> getLogAnalyticsResourcesWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getLogAnalyticsResources(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourcesResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourcesResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourcesResponseInner> clientResponse = getLogAnalyticsResourcesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourcesResponseInner> getLogAnalyticsResourcesDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourcesResponseInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourcesResponseInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WafMetricsResponseInner object if successful.
     */
    public WafMetricsResponseInner getWafLogAnalyticsMetrics(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity) {
        return getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity).toBlocking().single().body();
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, final ServiceCallback<WafMetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity), serviceCallback);
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafMetricsResponseInner object
     */
    public Observable<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity) {
        return getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity).map(new Func1<ServiceResponse<WafMetricsResponseInner>, WafMetricsResponseInner>() {
            @Override
            public WafMetricsResponseInner call(ServiceResponse<WafMetricsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafMetricsResponseInner object
     */
    public Observable<ServiceResponse<WafMetricsResponseInner>> getWafLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        Validator.validate(metrics);
        final List<WafAction> actions = null;
        final List<WafRankingGroupBy> groupBy = null;
        final List<WafRuleType> ruleTypes = null;
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return service.getWafLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, actionsConverted, groupByConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafMetricsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<WafMetricsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WafMetricsResponseInner> clientResponse = getWafLogAnalyticsMetricsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param actions the List&lt;WafAction&gt; value
     * @param groupBy the List&lt;WafRankingGroupBy&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WafMetricsResponseInner object if successful.
     */
    public WafMetricsResponseInner getWafLogAnalyticsMetrics(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        return getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).toBlocking().single().body();
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param actions the List&lt;WafAction&gt; value
     * @param groupBy the List&lt;WafRankingGroupBy&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes, final ServiceCallback<WafMetricsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes), serviceCallback);
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param actions the List&lt;WafAction&gt; value
     * @param groupBy the List&lt;WafRankingGroupBy&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafMetricsResponseInner object
     */
    public Observable<WafMetricsResponseInner> getWafLogAnalyticsMetricsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        return getWafLogAnalyticsMetricsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes).map(new Func1<ServiceResponse<WafMetricsResponseInner>, WafMetricsResponseInner>() {
            @Override
            public WafMetricsResponseInner call(ServiceResponse<WafMetricsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Waf related log analytics report for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param granularity Possible values include: 'PT5M', 'PT1H', 'P1D'
     * @param actions the List&lt;WafAction&gt; value
     * @param groupBy the List&lt;WafRankingGroupBy&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafMetricsResponseInner object
     */
    public Observable<ServiceResponse<WafMetricsResponseInner>> getWafLogAnalyticsMetricsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, WafGranularity granularity, List<WafAction> actions, List<WafRankingGroupBy> groupBy, List<WafRuleType> ruleTypes) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Parameter granularity is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(actions);
        Validator.validate(groupBy);
        Validator.validate(ruleTypes);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String groupByConverted = this.client.serializerAdapter().serializeList(groupBy, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return service.getWafLogAnalyticsMetrics(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, granularity, actionsConverted, groupByConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafMetricsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<WafMetricsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WafMetricsResponseInner> clientResponse = getWafLogAnalyticsMetricsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WafMetricsResponseInner> getWafLogAnalyticsMetricsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WafMetricsResponseInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WafMetricsResponseInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WafRankingsResponseInner object if successful.
     */
    public WafRankingsResponseInner getWafLogAnalyticsRankings(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        return getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings).toBlocking().single().body();
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, final ServiceCallback<WafRankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings), serviceCallback);
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafRankingsResponseInner object
     */
    public Observable<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        return getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings).map(new Func1<ServiceResponse<WafRankingsResponseInner>, WafRankingsResponseInner>() {
            @Override
            public WafRankingsResponseInner call(ServiceResponse<WafRankingsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafRankingsResponseInner object
     */
    public Observable<ServiceResponse<WafRankingsResponseInner>> getWafLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(rankings);
        final List<WafAction> actions = null;
        final List<WafRuleType> ruleTypes = null;
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return service.getWafLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, maxRanking, rankingsConverted, actionsConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafRankingsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<WafRankingsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WafRankingsResponseInner> clientResponse = getWafLogAnalyticsRankingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @param actions the List&lt;WafAction&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WafRankingsResponseInner object if successful.
     */
    public WafRankingsResponseInner getWafLogAnalyticsRankings(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        return getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).toBlocking().single().body();
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @param actions the List&lt;WafAction&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes, final ServiceCallback<WafRankingsResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes), serviceCallback);
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @param actions the List&lt;WafAction&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafRankingsResponseInner object
     */
    public Observable<WafRankingsResponseInner> getWafLogAnalyticsRankingsAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        return getWafLogAnalyticsRankingsWithServiceResponseAsync(resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes).map(new Func1<ServiceResponse<WafRankingsResponseInner>, WafRankingsResponseInner>() {
            @Override
            public WafRankingsResponseInner call(ServiceResponse<WafRankingsResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get WAF log analytics charts for AFD profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param metrics the List&lt;WafMetric&gt; value
     * @param dateTimeBegin the DateTime value
     * @param dateTimeEnd the DateTime value
     * @param maxRanking the int value
     * @param rankings the List&lt;WafRankingType&gt; value
     * @param actions the List&lt;WafAction&gt; value
     * @param ruleTypes the List&lt;WafRuleType&gt; value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WafRankingsResponseInner object
     */
    public Observable<ServiceResponse<WafRankingsResponseInner>> getWafLogAnalyticsRankingsWithServiceResponseAsync(String resourceGroupName, String profileName, List<WafMetric> metrics, DateTime dateTimeBegin, DateTime dateTimeEnd, int maxRanking, List<WafRankingType> rankings, List<WafAction> actions, List<WafRuleType> ruleTypes) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("Parameter metrics is required and cannot be null.");
        }
        if (dateTimeBegin == null) {
            throw new IllegalArgumentException("Parameter dateTimeBegin is required and cannot be null.");
        }
        if (dateTimeEnd == null) {
            throw new IllegalArgumentException("Parameter dateTimeEnd is required and cannot be null.");
        }
        if (rankings == null) {
            throw new IllegalArgumentException("Parameter rankings is required and cannot be null.");
        }
        Validator.validate(metrics);
        Validator.validate(rankings);
        Validator.validate(actions);
        Validator.validate(ruleTypes);
        String metricsConverted = this.client.serializerAdapter().serializeList(metrics, CollectionFormat.MULTI);
        String rankingsConverted = this.client.serializerAdapter().serializeList(rankings, CollectionFormat.MULTI);
        String actionsConverted = this.client.serializerAdapter().serializeList(actions, CollectionFormat.MULTI);
        String ruleTypesConverted = this.client.serializerAdapter().serializeList(ruleTypes, CollectionFormat.MULTI);
        return service.getWafLogAnalyticsRankings(this.client.subscriptionId(), resourceGroupName, profileName, this.client.apiVersion(), metricsConverted, dateTimeBegin, dateTimeEnd, maxRanking, rankingsConverted, actionsConverted, ruleTypesConverted, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WafRankingsResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<WafRankingsResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WafRankingsResponseInner> clientResponse = getWafLogAnalyticsRankingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WafRankingsResponseInner> getWafLogAnalyticsRankingsDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WafRankingsResponseInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WafRankingsResponseInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
