/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import java.util.List;
import com.microsoft.azure.management.cdn.ResourceReference;
import com.microsoft.azure.management.cdn.AFDEndpointProtocols;
import com.microsoft.azure.management.cdn.AfdQueryStringCachingBehavior;
import com.microsoft.azure.management.cdn.ForwardingProtocol;
import com.microsoft.azure.management.cdn.LinkToDefaultDomain;
import com.microsoft.azure.management.cdn.HttpsRedirect;
import com.microsoft.azure.management.cdn.EnabledState;
import com.microsoft.azure.management.cdn.AfdProvisioningState;
import com.microsoft.azure.management.cdn.DeploymentStatus;
import com.microsoft.azure.management.cdn.SystemData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * Friendly Routes name mapping to the any Routes or secret related
 * information.
 */
@JsonFlatten
public class RouteInner extends ProxyResource {
    /**
     * Domains referenced by this endpoint.
     */
    @JsonProperty(value = "properties.customDomains")
    private List<ResourceReference> customDomains;

    /**
     * A reference to the origin group.
     */
    @JsonProperty(value = "properties.originGroup", required = true)
    private ResourceReference originGroup;

    /**
     * A directory path on the origin that AzureFrontDoor can use to retrieve
     * content from, e.g. contoso.cloudapp.net/originpath.
     */
    @JsonProperty(value = "properties.originPath")
    private String originPath;

    /**
     * rule sets referenced by this endpoint.
     */
    @JsonProperty(value = "properties.ruleSets")
    private List<ResourceReference> ruleSets;

    /**
     * List of supported protocols for this route.
     */
    @JsonProperty(value = "properties.supportedProtocols")
    private List<AFDEndpointProtocols> supportedProtocols;

    /**
     * The route patterns of the rule.
     */
    @JsonProperty(value = "properties.patternsToMatch")
    private List<String> patternsToMatch;

    /**
     * compression settings.
     */
    @JsonProperty(value = "properties.compressionSettings")
    private Object compressionSettings;

    /**
     * Defines how CDN caches requests that include query strings. You can
     * ignore any query strings when caching, bypass caching to prevent
     * requests that contain query strings from being cached, or cache every
     * request with a unique URL. Possible values include: 'IgnoreQueryString',
     * 'UseQueryString', 'NotSet'.
     */
    @JsonProperty(value = "properties.queryStringCachingBehavior")
    private AfdQueryStringCachingBehavior queryStringCachingBehavior;

    /**
     * Protocol this rule will use when forwarding traffic to backends.
     * Possible values include: 'HttpOnly', 'HttpsOnly', 'MatchRequest'.
     */
    @JsonProperty(value = "properties.forwardingProtocol")
    private ForwardingProtocol forwardingProtocol;

    /**
     * whether this route will be linked to the default endpoint domain.
     * Possible values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.linkToDefaultDomain")
    private LinkToDefaultDomain linkToDefaultDomain;

    /**
     * Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     * that this is a easy way to set up this rule and it will be the first
     * rule that gets executed. Possible values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.httpsRedirect")
    private HttpsRedirect httpsRedirect;

    /**
     * Whether to enable use of this rule. Permitted values are 'Enabled' or
     * 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.enabledState")
    private EnabledState enabledState;

    /**
     * Provisioning status. Possible values include: 'Succeeded', 'Failed',
     * 'Updating', 'Deleting', 'Creating'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;

    /**
     * Possible values include: 'NotStarted', 'InProgress', 'Succeeded',
     * 'Failed'.
     */
    @JsonProperty(value = "properties.deploymentStatus", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;

    /**
     * The systemData property.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get domains referenced by this endpoint.
     *
     * @return the customDomains value
     */
    public List<ResourceReference> customDomains() {
        return this.customDomains;
    }

    /**
     * Set domains referenced by this endpoint.
     *
     * @param customDomains the customDomains value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withCustomDomains(List<ResourceReference> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    /**
     * Get a reference to the origin group.
     *
     * @return the originGroup value
     */
    public ResourceReference originGroup() {
        return this.originGroup;
    }

    /**
     * Set a reference to the origin group.
     *
     * @param originGroup the originGroup value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    /**
     * Get a directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     *
     * @return the originPath value
     */
    public String originPath() {
        return this.originPath;
    }

    /**
     * Set a directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
     *
     * @param originPath the originPath value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    /**
     * Get rule sets referenced by this endpoint.
     *
     * @return the ruleSets value
     */
    public List<ResourceReference> ruleSets() {
        return this.ruleSets;
    }

    /**
     * Set rule sets referenced by this endpoint.
     *
     * @param ruleSets the ruleSets value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withRuleSets(List<ResourceReference> ruleSets) {
        this.ruleSets = ruleSets;
        return this;
    }

    /**
     * Get list of supported protocols for this route.
     *
     * @return the supportedProtocols value
     */
    public List<AFDEndpointProtocols> supportedProtocols() {
        return this.supportedProtocols;
    }

    /**
     * Set list of supported protocols for this route.
     *
     * @param supportedProtocols the supportedProtocols value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withSupportedProtocols(List<AFDEndpointProtocols> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        return this;
    }

    /**
     * Get the route patterns of the rule.
     *
     * @return the patternsToMatch value
     */
    public List<String> patternsToMatch() {
        return this.patternsToMatch;
    }

    /**
     * Set the route patterns of the rule.
     *
     * @param patternsToMatch the patternsToMatch value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withPatternsToMatch(List<String> patternsToMatch) {
        this.patternsToMatch = patternsToMatch;
        return this;
    }

    /**
     * Get compression settings.
     *
     * @return the compressionSettings value
     */
    public Object compressionSettings() {
        return this.compressionSettings;
    }

    /**
     * Set compression settings.
     *
     * @param compressionSettings the compressionSettings value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withCompressionSettings(Object compressionSettings) {
        this.compressionSettings = compressionSettings;
        return this;
    }

    /**
     * Get defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'IgnoreQueryString', 'UseQueryString', 'NotSet'.
     *
     * @return the queryStringCachingBehavior value
     */
    public AfdQueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    /**
     * Set defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'IgnoreQueryString', 'UseQueryString', 'NotSet'.
     *
     * @param queryStringCachingBehavior the queryStringCachingBehavior value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withQueryStringCachingBehavior(AfdQueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    /**
     * Get protocol this rule will use when forwarding traffic to backends. Possible values include: 'HttpOnly', 'HttpsOnly', 'MatchRequest'.
     *
     * @return the forwardingProtocol value
     */
    public ForwardingProtocol forwardingProtocol() {
        return this.forwardingProtocol;
    }

    /**
     * Set protocol this rule will use when forwarding traffic to backends. Possible values include: 'HttpOnly', 'HttpsOnly', 'MatchRequest'.
     *
     * @param forwardingProtocol the forwardingProtocol value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        this.forwardingProtocol = forwardingProtocol;
        return this;
    }

    /**
     * Get whether this route will be linked to the default endpoint domain. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the linkToDefaultDomain value
     */
    public LinkToDefaultDomain linkToDefaultDomain() {
        return this.linkToDefaultDomain;
    }

    /**
     * Set whether this route will be linked to the default endpoint domain. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param linkToDefaultDomain the linkToDefaultDomain value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withLinkToDefaultDomain(LinkToDefaultDomain linkToDefaultDomain) {
        this.linkToDefaultDomain = linkToDefaultDomain;
        return this;
    }

    /**
     * Get whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the httpsRedirect value
     */
    public HttpsRedirect httpsRedirect() {
        return this.httpsRedirect;
    }

    /**
     * Set whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it will be the first rule that gets executed. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param httpsRedirect the httpsRedirect value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withHttpsRedirect(HttpsRedirect httpsRedirect) {
        this.httpsRedirect = httpsRedirect;
        return this;
    }

    /**
     * Get whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the enabledState value
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param enabledState the enabledState value to set
     * @return the RouteInner object itself.
     */
    public RouteInner withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Get provisioning status. Possible values include: 'Succeeded', 'Failed', 'Updating', 'Deleting', 'Creating'.
     *
     * @return the provisioningState value
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get possible values include: 'NotStarted', 'InProgress', 'Succeeded', 'Failed'.
     *
     * @return the deploymentStatus value
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the systemData value.
     *
     * @return the systemData value
     */
    public SystemData systemData() {
        return this.systemData;
    }

}
