/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in RuleSets.
 */
public class RuleSetsInner {
    /** The Retrofit service to perform REST calls. */
    private RuleSetsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of RuleSetsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RuleSetsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(RuleSetsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for RuleSets to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RuleSetsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets listByProfile" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets")
        Observable<Response<ResponseBody>> listByProfile(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets listResourceUsage" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/usages")
        Observable<Response<ResponseBody>> listResourceUsage(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets listByProfileNext" })
        @GET
        Observable<Response<ResponseBody>> listByProfileNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.RuleSets listResourceUsageNext" })
        @GET
        Observable<Response<ResponseBody>> listResourceUsageNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RuleSetInner&gt; object if successful.
     */
    public PagedList<RuleSetInner> listByProfile(final String resourceGroupName, final String profileName) {
        ServiceResponse<Page<RuleSetInner>> response = listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<RuleSetInner>(response.body()) {
            @Override
            public Page<RuleSetInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RuleSetInner>> listByProfileAsync(final String resourceGroupName, final String profileName, final ListOperationCallback<RuleSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileSinglePageAsync(resourceGroupName, profileName),
            new Func1<String, Observable<ServiceResponse<Page<RuleSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleSetInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleSetInner&gt; object
     */
    public Observable<Page<RuleSetInner>> listByProfileAsync(final String resourceGroupName, final String profileName) {
        return listByProfileWithServiceResponseAsync(resourceGroupName, profileName)
            .map(new Func1<ServiceResponse<Page<RuleSetInner>>, Page<RuleSetInner>>() {
                @Override
                public Page<RuleSetInner> call(ServiceResponse<Page<RuleSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RuleSetInner>>> listByProfileWithServiceResponseAsync(final String resourceGroupName, final String profileName) {
        return listByProfileSinglePageAsync(resourceGroupName, profileName)
            .concatMap(new Func1<ServiceResponse<Page<RuleSetInner>>, Observable<ServiceResponse<Page<RuleSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleSetInner>>> call(ServiceResponse<Page<RuleSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
    ServiceResponse<PageImpl<RuleSetInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<RuleSetInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RuleSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RuleSetInner>>> listByProfileSinglePageAsync(final String resourceGroupName, final String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RuleSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RuleSetInner>> result = listByProfileDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RuleSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RuleSetInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RuleSetInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RuleSetInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleSetInner object if successful.
     */
    public RuleSetInner get(String resourceGroupName, String profileName, String ruleSetName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).toBlocking().single().body();
    }

    /**
     * Gets an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleSetInner> getAsync(String resourceGroupName, String profileName, String ruleSetName, final ServiceCallback<RuleSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName), serviceCallback);
    }

    /**
     * Gets an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleSetInner object
     */
    public Observable<RuleSetInner> getAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).map(new Func1<ServiceResponse<RuleSetInner>, RuleSetInner>() {
            @Override
            public RuleSetInner call(ServiceResponse<RuleSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleSetInner object
     */
    public Observable<ServiceResponse<RuleSetInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RuleSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RuleSetInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RuleSetInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RuleSetInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RuleSetInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleSetInner object if successful.
     */
    public RuleSetInner create(String resourceGroupName, String profileName, String ruleSetName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).toBlocking().last().body();
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleSetInner> createAsync(String resourceGroupName, String profileName, String ruleSetName, final ServiceCallback<RuleSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName), serviceCallback);
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RuleSetInner> createAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).map(new Func1<ServiceResponse<RuleSetInner>, RuleSetInner>() {
            @Override
            public RuleSetInner call(ServiceResponse<RuleSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RuleSetInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RuleSetInner>() { }.getType());
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleSetInner object if successful.
     */
    public RuleSetInner beginCreate(String resourceGroupName, String profileName, String ruleSetName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).toBlocking().single().body();
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleSetInner> beginCreateAsync(String resourceGroupName, String profileName, String ruleSetName, final ServiceCallback<RuleSetInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName), serviceCallback);
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleSetInner object
     */
    public Observable<RuleSetInner> beginCreateAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).map(new Func1<ServiceResponse<RuleSetInner>, RuleSetInner>() {
            @Override
            public RuleSetInner call(ServiceResponse<RuleSetInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new rule set within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleSetInner object
     */
    public Observable<ServiceResponse<RuleSetInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginCreate(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleSetInner>>>() {
                @Override
                public Observable<ServiceResponse<RuleSetInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RuleSetInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RuleSetInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RuleSetInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RuleSetInner>() { }.getType())
                .register(201, new TypeToken<RuleSetInner>() { }.getType())
                .register(202, new TypeToken<RuleSetInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String ruleSetName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).toBlocking().last().body();
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String ruleSetName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName), serviceCallback);
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String ruleSetName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).toBlocking().single().body();
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String ruleSetName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName), serviceCallback);
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String ruleSetName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing AzureFrontDoor rule set with the specified rule set name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;UsageInner&gt; object if successful.
     */
    public PagedList<UsageInner> listResourceUsage(final String resourceGroupName, final String profileName, final String ruleSetName) {
        ServiceResponse<Page<UsageInner>> response = listResourceUsageSinglePageAsync(resourceGroupName, profileName, ruleSetName).toBlocking().single();
        return new PagedList<UsageInner>(response.body()) {
            @Override
            public Page<UsageInner> nextPage(String nextPageLink) {
                return listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listResourceUsageAsync(final String resourceGroupName, final String profileName, final String ruleSetName, final ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listResourceUsageSinglePageAsync(resourceGroupName, profileName, ruleSetName),
            new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                    return listResourceUsageNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<Page<UsageInner>> listResourceUsageAsync(final String resourceGroupName, final String profileName, final String ruleSetName) {
        return listResourceUsageWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName)
            .map(new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>() {
                @Override
                public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String ruleSetName) {
        return listResourceUsageSinglePageAsync(resourceGroupName, profileName, ruleSetName)
            .concatMap(new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listResourceUsageNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
    ServiceResponse<PageImpl<UsageInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<UsageInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<UsageInner>> * @param ruleSetName Name of the rule set under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;UsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageSinglePageAsync(final String resourceGroupName, final String profileName, final String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listResourceUsage(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listResourceUsageDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RuleSetInner&gt; object if successful.
     */
    public PagedList<RuleSetInner> listByProfileNext(final String nextPageLink) {
        ServiceResponse<Page<RuleSetInner>> response = listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RuleSetInner>(response.body()) {
            @Override
            public Page<RuleSetInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RuleSetInner>> listByProfileNextAsync(final String nextPageLink, final ServiceFuture<List<RuleSetInner>> serviceFuture, final ListOperationCallback<RuleSetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RuleSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleSetInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleSetInner&gt; object
     */
    public Observable<Page<RuleSetInner>> listByProfileNextAsync(final String nextPageLink) {
        return listByProfileNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RuleSetInner>>, Page<RuleSetInner>>() {
                @Override
                public Page<RuleSetInner> call(ServiceResponse<Page<RuleSetInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleSetInner&gt; object
     */
    public Observable<ServiceResponse<Page<RuleSetInner>>> listByProfileNextWithServiceResponseAsync(final String nextPageLink) {
        return listByProfileNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RuleSetInner>>, Observable<ServiceResponse<Page<RuleSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleSetInner>>> call(ServiceResponse<Page<RuleSetInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor rule sets within a profile.
     *
    ServiceResponse<PageImpl<RuleSetInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RuleSetInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RuleSetInner>>> listByProfileNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RuleSetInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleSetInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RuleSetInner>> result = listByProfileNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RuleSetInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RuleSetInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RuleSetInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RuleSetInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;UsageInner&gt; object if successful.
     */
    public PagedList<UsageInner> listResourceUsageNext(final String nextPageLink) {
        ServiceResponse<Page<UsageInner>> response = listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<UsageInner>(response.body()) {
            @Override
            public Page<UsageInner> nextPage(String nextPageLink) {
                return listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listResourceUsageNextAsync(final String nextPageLink, final ServiceFuture<List<UsageInner>> serviceFuture, final ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listResourceUsageNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                    return listResourceUsageNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<Page<UsageInner>> listResourceUsageNextAsync(final String nextPageLink) {
        return listResourceUsageNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>() {
                @Override
                public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageNextWithServiceResponseAsync(final String nextPageLink) {
        return listResourceUsageNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listResourceUsageNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
    ServiceResponse<PageImpl<UsageInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;UsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listResourceUsageNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listResourceUsageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listResourceUsageNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
