/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.RuleUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Rules.
 */
public class RulesInner {
    /** The Retrofit service to perform REST calls. */
    private RulesService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of RulesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public RulesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(RulesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Rules to be
     * used by Retrofit to perform actually REST calls.
     */
    interface RulesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules listByRuleSet" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules")
        Observable<Response<ResponseBody>> listByRuleSet(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Body RuleInner rule, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Body RuleInner rule, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Body RuleUpdateParameters ruleUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Body RuleUpdateParameters ruleUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("ruleSetName") String ruleSetName, @Path("ruleName") String ruleName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Rules listByRuleSetNext" })
        @GET
        Observable<Response<ResponseBody>> listByRuleSetNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RuleInner&gt; object if successful.
     */
    public PagedList<RuleInner> listByRuleSet(final String resourceGroupName, final String profileName, final String ruleSetName) {
        ServiceResponse<Page<RuleInner>> response = listByRuleSetSinglePageAsync(resourceGroupName, profileName, ruleSetName).toBlocking().single();
        return new PagedList<RuleInner>(response.body()) {
            @Override
            public Page<RuleInner> nextPage(String nextPageLink) {
                return listByRuleSetNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RuleInner>> listByRuleSetAsync(final String resourceGroupName, final String profileName, final String ruleSetName, final ListOperationCallback<RuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByRuleSetSinglePageAsync(resourceGroupName, profileName, ruleSetName),
            new Func1<String, Observable<ServiceResponse<Page<RuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleInner>>> call(String nextPageLink) {
                    return listByRuleSetNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleInner&gt; object
     */
    public Observable<Page<RuleInner>> listByRuleSetAsync(final String resourceGroupName, final String profileName, final String ruleSetName) {
        return listByRuleSetWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName)
            .map(new Func1<ServiceResponse<Page<RuleInner>>, Page<RuleInner>>() {
                @Override
                public Page<RuleInner> call(ServiceResponse<Page<RuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String ruleSetName) {
        return listByRuleSetSinglePageAsync(resourceGroupName, profileName, ruleSetName)
            .concatMap(new Func1<ServiceResponse<Page<RuleInner>>, Observable<ServiceResponse<Page<RuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleInner>>> call(ServiceResponse<Page<RuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByRuleSetNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
    ServiceResponse<PageImpl<RuleInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<RuleInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<RuleInner>> * @param ruleSetName Name of the rule set under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetSinglePageAsync(final String resourceGroupName, final String profileName, final String ruleSetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByRuleSet(resourceGroupName, profileName, ruleSetName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RuleInner>> result = listByRuleSetDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RuleInner>> listByRuleSetDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RuleInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RuleInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleInner object if successful.
     */
    public RuleInner get(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).toBlocking().single().body();
    }

    /**
     * Gets an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleInner> getAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, final ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName), serviceCallback);
    }

    /**
     * Gets an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleInner object
     */
    public Observable<RuleInner> getAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).map(new Func1<ServiceResponse<RuleInner>, RuleInner>() {
            @Override
            public RuleInner call(ServiceResponse<RuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleInner object
     */
    public Observable<ServiceResponse<RuleInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleInner>>>() {
                @Override
                public Observable<ServiceResponse<RuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RuleInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RuleInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RuleInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RuleInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleInner object if successful.
     */
    public RuleInner create(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).toBlocking().last().body();
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleInner> createAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule, final ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule), serviceCallback);
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RuleInner> createAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).map(new Func1<ServiceResponse<RuleInner>, RuleInner>() {
            @Override
            public RuleInner call(ServiceResponse<RuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RuleInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Parameter rule is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(rule);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), rule, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RuleInner>() { }.getType());
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleInner object if successful.
     */
    public RuleInner beginCreate(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).toBlocking().single().body();
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleInner> beginCreateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule, final ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule), serviceCallback);
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleInner object
     */
    public Observable<RuleInner> beginCreateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, rule).map(new Func1<ServiceResponse<RuleInner>, RuleInner>() {
            @Override
            public RuleInner call(ServiceResponse<RuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new delivery rule within the specified rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param rule The delivery rule properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleInner object
     */
    public Observable<ServiceResponse<RuleInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleInner rule) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Parameter rule is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(rule);
        return service.beginCreate(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), rule, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleInner>>>() {
                @Override
                public Observable<ServiceResponse<RuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RuleInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RuleInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RuleInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RuleInner>() { }.getType())
                .register(201, new TypeToken<RuleInner>() { }.getType())
                .register(202, new TypeToken<RuleInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleInner object if successful.
     */
    public RuleInner update(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).toBlocking().last().body();
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleInner> updateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties, final ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<RuleInner> updateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).map(new Func1<ServiceResponse<RuleInner>, RuleInner>() {
            @Override
            public RuleInner call(ServiceResponse<RuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<RuleInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (ruleUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter ruleUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(ruleUpdateProperties);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), ruleUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RuleInner>() { }.getType());
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RuleInner object if successful.
     */
    public RuleInner beginUpdate(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).toBlocking().single().body();
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RuleInner> beginUpdateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties, final ServiceCallback<RuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleInner object
     */
    public Observable<RuleInner> beginUpdateAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName, ruleUpdateProperties).map(new Func1<ServiceResponse<RuleInner>, RuleInner>() {
            @Override
            public RuleInner call(ServiceResponse<RuleInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param ruleUpdateProperties Delivery rule properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RuleInner object
     */
    public Observable<ServiceResponse<RuleInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, RuleUpdateParameters ruleUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (ruleUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter ruleUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(ruleUpdateProperties);
        return service.beginUpdate(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), ruleUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RuleInner>>>() {
                @Override
                public Observable<ServiceResponse<RuleInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RuleInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RuleInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RuleInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RuleInner>() { }.getType())
                .register(202, new TypeToken<RuleInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).toBlocking().last().body();
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName), serviceCallback);
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).toBlocking().single().body();
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName), serviceCallback);
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, ruleSetName, ruleName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing delivery rule within a rule set.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param ruleSetName Name of the rule set under the profile.
     * @param ruleName Name of the delivery rule which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String ruleSetName, String ruleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (ruleSetName == null) {
            throw new IllegalArgumentException("Parameter ruleSetName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, ruleSetName, ruleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RuleInner&gt; object if successful.
     */
    public PagedList<RuleInner> listByRuleSetNext(final String nextPageLink) {
        ServiceResponse<Page<RuleInner>> response = listByRuleSetNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RuleInner>(response.body()) {
            @Override
            public Page<RuleInner> nextPage(String nextPageLink) {
                return listByRuleSetNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RuleInner>> listByRuleSetNextAsync(final String nextPageLink, final ServiceFuture<List<RuleInner>> serviceFuture, final ListOperationCallback<RuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByRuleSetNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleInner>>> call(String nextPageLink) {
                    return listByRuleSetNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleInner&gt; object
     */
    public Observable<Page<RuleInner>> listByRuleSetNextAsync(final String nextPageLink) {
        return listByRuleSetNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RuleInner>>, Page<RuleInner>>() {
                @Override
                public Page<RuleInner> call(ServiceResponse<Page<RuleInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RuleInner&gt; object
     */
    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetNextWithServiceResponseAsync(final String nextPageLink) {
        return listByRuleSetNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RuleInner>>, Observable<ServiceResponse<Page<RuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleInner>>> call(ServiceResponse<Page<RuleInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByRuleSetNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing delivery rules within a rule set.
     *
    ServiceResponse<PageImpl<RuleInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RuleInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RuleInner>>> listByRuleSetNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByRuleSetNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RuleInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RuleInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RuleInner>> result = listByRuleSetNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RuleInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RuleInner>> listByRuleSetNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RuleInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RuleInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
