/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AfdQueryStringCachingBehavior.
 */
public enum AfdQueryStringCachingBehavior {
    /** Enum value IgnoreQueryString. */
    IGNORE_QUERY_STRING("IgnoreQueryString"),

    /** Enum value UseQueryString. */
    USE_QUERY_STRING("UseQueryString"),

    /** Enum value NotSet. */
    NOT_SET("NotSet");

    /** The actual serialized value for a AfdQueryStringCachingBehavior instance. */
    private String value;

    AfdQueryStringCachingBehavior(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AfdQueryStringCachingBehavior instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed AfdQueryStringCachingBehavior object, or null if unable to parse.
     */
    @JsonCreator
    public static AfdQueryStringCachingBehavior fromString(String value) {
        AfdQueryStringCachingBehavior[] items = AfdQueryStringCachingBehavior.values();
        for (AfdQueryStringCachingBehavior item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
