/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * The customDomain JSON object required for custom domain creation or update.
 */
@JsonFlatten
public class CustomDomainParameters {
    /**
     * The host name of the custom domain. Must be a domain name.
     */
    @JsonProperty(value = "properties.hostName", required = true)
    private String hostName;

    /**
     * Get the host name of the custom domain. Must be a domain name.
     *
     * @return the hostName value
     */
    public String hostName() {
        return this.hostName;
    }

    /**
     * Set the host name of the custom domain. Must be a domain name.
     *
     * @param hostName the hostName value to set
     * @return the CustomDomainParameters object itself.
     */
    public CustomDomainParameters withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

}
