/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for MinimumTlsVersion.
 */
public enum MinimumTlsVersion {
    /** Enum value None. */
    NONE("None"),

    /** Enum value TLS10. */
    TLS10("TLS10"),

    /** Enum value TLS12. */
    TLS12("TLS12");

    /** The actual serialized value for a MinimumTlsVersion instance. */
    private String value;

    MinimumTlsVersion(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a MinimumTlsVersion instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed MinimumTlsVersion object, or null if unable to parse.
     */
    @JsonCreator
    public static MinimumTlsVersion fromString(String value) {
        MinimumTlsVersion[] items = MinimumTlsVersion.values();
        for (MinimumTlsVersion item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
