/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines a rate limiting rule that can be included in a waf policy.
 */
public class RateLimitRule extends CustomRule {
    /**
     * Defines rate limit threshold.
     */
    @JsonProperty(value = "rateLimitThreshold", required = true)
    private int rateLimitThreshold;

    /**
     * Defines rate limit duration. Default is 1 minute.
     */
    @JsonProperty(value = "rateLimitDurationInMinutes", required = true)
    private int rateLimitDurationInMinutes;

    /**
     * Get defines rate limit threshold.
     *
     * @return the rateLimitThreshold value
     */
    public int rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    /**
     * Set defines rate limit threshold.
     *
     * @param rateLimitThreshold the rateLimitThreshold value to set
     * @return the RateLimitRule object itself.
     */
    public RateLimitRule withRateLimitThreshold(int rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    /**
     * Get defines rate limit duration. Default is 1 minute.
     *
     * @return the rateLimitDurationInMinutes value
     */
    public int rateLimitDurationInMinutes() {
        return this.rateLimitDurationInMinutes;
    }

    /**
     * Set defines rate limit duration. Default is 1 minute.
     *
     * @param rateLimitDurationInMinutes the rateLimitDurationInMinutes value to set
     * @return the RateLimitRule object itself.
     */
    public RateLimitRule withRateLimitDurationInMinutes(int rateLimitDurationInMinutes) {
        this.rateLimitDurationInMinutes = rateLimitDurationInMinutes;
        return this;
    }

}
