/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the parameters for the Url Signing action.
 */
public class UrlSigningActionParameters {
    /**
     * The odatatype property.
     */
    @JsonProperty(value = "@odata\\.type", required = true)
    private String odatatype;

    /**
     * Algorithm to use for URL signing. Possible values include: 'SHA256'.
     */
    @JsonProperty(value = "algorithm")
    private Algorithm algorithm;

    /**
     * Defines which query string parameters in the url to be considered for
     * expires, key id etc.
     */
    @JsonProperty(value = "parameterNameOverride")
    private List<UrlSigningParamIdentifier> parameterNameOverride;

    /**
     * Creates an instance of UrlSigningActionParameters class.
     */
    public UrlSigningActionParameters() {
        odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters";
    }

    /**
     * Get the odatatype value.
     *
     * @return the odatatype value
     */
    public String odatatype() {
        return this.odatatype;
    }

    /**
     * Set the odatatype value.
     *
     * @param odatatype the odatatype value to set
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withOdatatype(String odatatype) {
        this.odatatype = odatatype;
        return this;
    }

    /**
     * Get algorithm to use for URL signing. Possible values include: 'SHA256'.
     *
     * @return the algorithm value
     */
    public Algorithm algorithm() {
        return this.algorithm;
    }

    /**
     * Set algorithm to use for URL signing. Possible values include: 'SHA256'.
     *
     * @param algorithm the algorithm value to set
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get defines which query string parameters in the url to be considered for expires, key id etc.
     *
     * @return the parameterNameOverride value
     */
    public List<UrlSigningParamIdentifier> parameterNameOverride() {
        return this.parameterNameOverride;
    }

    /**
     * Set defines which query string parameters in the url to be considered for expires, key id etc.
     *
     * @param parameterNameOverride the parameterNameOverride value to set
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withParameterNameOverride(List<UrlSigningParamIdentifier> parameterNameOverride) {
        this.parameterNameOverride = parameterNameOverride;
        return this;
    }

}
