/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Url signing key parameters.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type", defaultImpl = UrlSigningKeyParameters.class)
@JsonTypeName("UrlSigningKey")
public class UrlSigningKeyParameters extends SecretParameters {
    /**
     * Defines the customer defined key Id. This id will exist in the incoming
     * request to indicate the key used to form the hash.
     */
    @JsonProperty(value = "keyId", required = true)
    private String keyId;

    /**
     * Resource reference to the KV secret.
     */
    @JsonProperty(value = "secretSource", required = true)
    private ResourceReference secretSource;

    /**
     * Version of the secret to be used.
     */
    @JsonProperty(value = "secretVersion")
    private String secretVersion;

    /**
     * Get defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
     *
     * @return the keyId value
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form the hash.
     *
     * @param keyId the keyId value to set
     * @return the UrlSigningKeyParameters object itself.
     */
    public UrlSigningKeyParameters withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get resource reference to the KV secret.
     *
     * @return the secretSource value
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set resource reference to the KV secret.
     *
     * @param secretSource the secretSource value to set
     * @return the UrlSigningKeyParameters object itself.
     */
    public UrlSigningKeyParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get version of the secret to be used.
     *
     * @return the secretVersion value
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set version of the secret to be used.
     *
     * @param secretVersion the secretVersion value to set
     * @return the UrlSigningKeyParameters object itself.
     */
    public UrlSigningKeyParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

}
