/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.AFDOriginUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in AFDOrigins.
 */
public class AFDOriginsInner {
    /** The Retrofit service to perform REST calls. */
    private AFDOriginsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of AFDOriginsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AFDOriginsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(AFDOriginsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AFDOrigins to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AFDOriginsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins listByOriginGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins")
        Observable<Response<ResponseBody>> listByOriginGroup(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Body AFDOriginInner origin, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Body AFDOriginInner origin, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Body AFDOriginUpdateParameters originUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Body AFDOriginUpdateParameters originUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("originGroupName") String originGroupName, @Path("originName") String originName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.AFDOrigins listByOriginGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByOriginGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AFDOriginInner&gt; object if successful.
     */
    public PagedList<AFDOriginInner> listByOriginGroup(final String resourceGroupName, final String profileName, final String originGroupName) {
        ServiceResponse<Page<AFDOriginInner>> response = listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName).toBlocking().single();
        return new PagedList<AFDOriginInner>(response.body()) {
            @Override
            public Page<AFDOriginInner> nextPage(String nextPageLink) {
                return listByOriginGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AFDOriginInner>> listByOriginGroupAsync(final String resourceGroupName, final String profileName, final String originGroupName, final ListOperationCallback<AFDOriginInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName),
            new Func1<String, Observable<ServiceResponse<Page<AFDOriginInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDOriginInner>>> call(String nextPageLink) {
                    return listByOriginGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDOriginInner&gt; object
     */
    public Observable<Page<AFDOriginInner>> listByOriginGroupAsync(final String resourceGroupName, final String profileName, final String originGroupName) {
        return listByOriginGroupWithServiceResponseAsync(resourceGroupName, profileName, originGroupName)
            .map(new Func1<ServiceResponse<Page<AFDOriginInner>>, Page<AFDOriginInner>>() {
                @Override
                public Page<AFDOriginInner> call(ServiceResponse<Page<AFDOriginInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDOriginInner&gt; object
     */
    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String originGroupName) {
        return listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName)
            .concatMap(new Func1<ServiceResponse<Page<AFDOriginInner>>, Observable<ServiceResponse<Page<AFDOriginInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDOriginInner>>> call(ServiceResponse<Page<AFDOriginInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByOriginGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
    ServiceResponse<PageImpl<AFDOriginInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<AFDOriginInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<AFDOriginInner>> * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AFDOriginInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupSinglePageAsync(final String resourceGroupName, final String profileName, final String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByOriginGroup(resourceGroupName, profileName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDOriginInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDOriginInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AFDOriginInner>> result = listByOriginGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AFDOriginInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AFDOriginInner>> listByOriginGroupDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AFDOriginInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AFDOriginInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDOriginInner object if successful.
     */
    public AFDOriginInner get(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).toBlocking().single().body();
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDOriginInner> getAsync(String resourceGroupName, String profileName, String originGroupName, String originName, final ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName), serviceCallback);
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDOriginInner object
     */
    public Observable<AFDOriginInner> getAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).map(new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>() {
            @Override
            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDOriginInner object
     */
    public Observable<ServiceResponse<AFDOriginInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDOriginInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDOriginInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AFDOriginInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AFDOriginInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AFDOriginInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDOriginInner object if successful.
     */
    public AFDOriginInner create(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).toBlocking().last().body();
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDOriginInner> createAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin, final ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin), serviceCallback);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AFDOriginInner> createAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).map(new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>() {
            @Override
            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AFDOriginInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Parameter origin is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(origin);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), origin, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDOriginInner>() { }.getType());
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDOriginInner object if successful.
     */
    public AFDOriginInner beginCreate(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).toBlocking().single().body();
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDOriginInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin, final ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin), serviceCallback);
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDOriginInner object
     */
    public Observable<AFDOriginInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin).map(new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>() {
            @Override
            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new origin within the specified origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin that is unique within the profile.
     * @param origin Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDOriginInner object
     */
    public Observable<ServiceResponse<AFDOriginInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginInner origin) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Parameter origin is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(origin);
        return service.beginCreate(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), origin, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDOriginInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDOriginInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AFDOriginInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AFDOriginInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AFDOriginInner>() { }.getType())
                .register(201, new TypeToken<AFDOriginInner>() { }.getType())
                .register(202, new TypeToken<AFDOriginInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDOriginInner object if successful.
     */
    public AFDOriginInner update(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).toBlocking().last().body();
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDOriginInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties, final ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AFDOriginInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).map(new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>() {
            @Override
            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AFDOriginInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(originUpdateProperties);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), originUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AFDOriginInner>() { }.getType());
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AFDOriginInner object if successful.
     */
    public AFDOriginInner beginUpdate(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).toBlocking().single().body();
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AFDOriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties, final ServiceCallback<AFDOriginInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDOriginInner object
     */
    public Observable<AFDOriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).map(new Func1<ServiceResponse<AFDOriginInner>, AFDOriginInner>() {
            @Override
            public AFDOriginInner call(ServiceResponse<AFDOriginInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param originUpdateProperties Origin properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AFDOriginInner object
     */
    public Observable<ServiceResponse<AFDOriginInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AFDOriginUpdateParameters originUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(originUpdateProperties);
        return service.beginUpdate(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), originUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AFDOriginInner>>>() {
                @Override
                public Observable<ServiceResponse<AFDOriginInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AFDOriginInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AFDOriginInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AFDOriginInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AFDOriginInner>() { }.getType())
                .register(202, new TypeToken<AFDOriginInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).toBlocking().last().body();
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName), serviceCallback);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).toBlocking().single().body();
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName), serviceCallback);
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, originGroupName, originName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing origin within an origin group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originName Name of the origin which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (originName == null) {
            throw new IllegalArgumentException("Parameter originName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, originGroupName, originName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AFDOriginInner&gt; object if successful.
     */
    public PagedList<AFDOriginInner> listByOriginGroupNext(final String nextPageLink) {
        ServiceResponse<Page<AFDOriginInner>> response = listByOriginGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AFDOriginInner>(response.body()) {
            @Override
            public Page<AFDOriginInner> nextPage(String nextPageLink) {
                return listByOriginGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AFDOriginInner>> listByOriginGroupNextAsync(final String nextPageLink, final ServiceFuture<List<AFDOriginInner>> serviceFuture, final ListOperationCallback<AFDOriginInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByOriginGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AFDOriginInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDOriginInner>>> call(String nextPageLink) {
                    return listByOriginGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDOriginInner&gt; object
     */
    public Observable<Page<AFDOriginInner>> listByOriginGroupNextAsync(final String nextPageLink) {
        return listByOriginGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AFDOriginInner>>, Page<AFDOriginInner>>() {
                @Override
                public Page<AFDOriginInner> call(ServiceResponse<Page<AFDOriginInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AFDOriginInner&gt; object
     */
    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByOriginGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AFDOriginInner>>, Observable<ServiceResponse<Page<AFDOriginInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDOriginInner>>> call(ServiceResponse<Page<AFDOriginInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByOriginGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing origins within an origin group.
     *
    ServiceResponse<PageImpl<AFDOriginInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AFDOriginInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AFDOriginInner>>> listByOriginGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByOriginGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AFDOriginInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AFDOriginInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AFDOriginInner>> result = listByOriginGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AFDOriginInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AFDOriginInner>> listByOriginGroupNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AFDOriginInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AFDOriginInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
