/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.EndpointUpdateParameters;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.LoadParameters;
import com.microsoft.azure.management.cdn.PurgeParameters;
import com.microsoft.azure.management.cdn.ValidateCustomDomainInput;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Endpoints.
 */
public class EndpointsInner {
    /** The Retrofit service to perform REST calls. */
    private EndpointsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of EndpointsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public EndpointsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(EndpointsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Endpoints to be
     * used by Retrofit to perform actually REST calls.
     */
    interface EndpointsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listByProfile" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints")
        Observable<Response<ResponseBody>> listByProfile(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Body EndpointInner endpoint, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Body EndpointInner endpoint, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Body EndpointUpdateParameters endpointUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Body EndpointUpdateParameters endpointUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints start" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start")
        Observable<Response<ResponseBody>> start(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginStart" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start")
        Observable<Response<ResponseBody>> beginStart(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints stop" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop")
        Observable<Response<ResponseBody>> stop(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginStop" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop")
        Observable<Response<ResponseBody>> beginStop(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints purgeContent" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge")
        Observable<Response<ResponseBody>> purgeContent(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body PurgeParameters contentFilePaths, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginPurgeContent" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge")
        Observable<Response<ResponseBody>> beginPurgeContent(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body PurgeParameters contentFilePaths, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints loadContent" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load")
        Observable<Response<ResponseBody>> loadContent(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body LoadParameters contentFilePaths, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginLoadContent" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load")
        Observable<Response<ResponseBody>> beginLoadContent(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body LoadParameters contentFilePaths, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints validateCustomDomain" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/validateCustomDomain")
        Observable<Response<ResponseBody>> validateCustomDomain(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ValidateCustomDomainInput customDomainProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listResourceUsage" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/checkResourceUsage")
        Observable<Response<ResponseBody>> listResourceUsage(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listByProfileNext" })
        @GET
        Observable<Response<ResponseBody>> listByProfileNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listResourceUsageNext" })
        @GET
        Observable<Response<ResponseBody>> listResourceUsageNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;EndpointInner&gt; object if successful.
     */
    public PagedList<EndpointInner> listByProfile(final String resourceGroupName, final String profileName) {
        ServiceResponse<Page<EndpointInner>> response = listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<EndpointInner>(response.body()) {
            @Override
            public Page<EndpointInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<EndpointInner>> listByProfileAsync(final String resourceGroupName, final String profileName, final ListOperationCallback<EndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileSinglePageAsync(resourceGroupName, profileName),
            new Func1<String, Observable<ServiceResponse<Page<EndpointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EndpointInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EndpointInner&gt; object
     */
    public Observable<Page<EndpointInner>> listByProfileAsync(final String resourceGroupName, final String profileName) {
        return listByProfileWithServiceResponseAsync(resourceGroupName, profileName)
            .map(new Func1<ServiceResponse<Page<EndpointInner>>, Page<EndpointInner>>() {
                @Override
                public Page<EndpointInner> call(ServiceResponse<Page<EndpointInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EndpointInner&gt; object
     */
    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileWithServiceResponseAsync(final String resourceGroupName, final String profileName) {
        return listByProfileSinglePageAsync(resourceGroupName, profileName)
            .concatMap(new Func1<ServiceResponse<Page<EndpointInner>>, Observable<ServiceResponse<Page<EndpointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EndpointInner>>> call(ServiceResponse<Page<EndpointInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing CDN endpoints.
     *
    ServiceResponse<PageImpl<EndpointInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<EndpointInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;EndpointInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileSinglePageAsync(final String resourceGroupName, final String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EndpointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EndpointInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<EndpointInner>> result = listByProfileDelegate(response);
                        return Observable.just(new ServiceResponse<Page<EndpointInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<EndpointInner>> listByProfileDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<EndpointInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<EndpointInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner get(String resourceGroupName, String profileName, String endpointName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single().body();
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<EndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<ServiceResponse<EndpointInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>() {
                @Override
                public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EndpointInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EndpointInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EndpointInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EndpointInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner create(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).toBlocking().last().body();
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint), serviceCallback);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<EndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<EndpointInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Parameter endpoint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(endpoint);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpoint, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<EndpointInner>() { }.getType());
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner beginCreate(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).toBlocking().single().body();
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint), serviceCallback);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<EndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<ServiceResponse<EndpointInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Parameter endpoint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(endpoint);
        return service.beginCreate(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpoint, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>() {
                @Override
                public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EndpointInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EndpointInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EndpointInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EndpointInner>() { }.getType())
                .register(201, new TypeToken<EndpointInner>() { }.getType())
                .register(202, new TypeToken<EndpointInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner update(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).toBlocking().last().body();
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<EndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<EndpointInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpointUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(endpointUpdateProperties);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpointUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<EndpointInner>() { }.getType());
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner beginUpdate(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).toBlocking().single().body();
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<EndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<ServiceResponse<EndpointInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParameters endpointUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpointUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(endpointUpdateProperties);
        return service.beginUpdate(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpointUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>() {
                @Override
                public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EndpointInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EndpointInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EndpointInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EndpointInner>() { }.getType())
                .register(202, new TypeToken<EndpointInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String endpointName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().last().body();
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String endpointName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single().body();
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner start(String resourceGroupName, String profileName, String endpointName) {
        return startWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().last().body();
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(startWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName) {
        return startWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<EndpointInner>> startWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.start(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<EndpointInner>() { }.getType());
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner beginStart(String resourceGroupName, String profileName, String endpointName) {
        return beginStartWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single().body();
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> beginStartAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginStartWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<EndpointInner> beginStartAsync(String resourceGroupName, String profileName, String endpointName) {
        return beginStartWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<ServiceResponse<EndpointInner>> beginStartWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginStart(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>() {
                @Override
                public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EndpointInner> clientResponse = beginStartDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EndpointInner> beginStartDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EndpointInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EndpointInner>() { }.getType())
                .register(202, new TypeToken<EndpointInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner stop(String resourceGroupName, String profileName, String endpointName) {
        return stopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().last().body();
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(stopWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName) {
        return stopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<EndpointInner>> stopWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.stop(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<EndpointInner>() { }.getType());
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the EndpointInner object if successful.
     */
    public EndpointInner beginStop(String resourceGroupName, String profileName, String endpointName) {
        return beginStopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single().body();
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<EndpointInner> beginStopAsync(String resourceGroupName, String profileName, String endpointName, final ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginStopWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<EndpointInner> beginStopAsync(String resourceGroupName, String profileName, String endpointName) {
        return beginStopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map(new Func1<ServiceResponse<EndpointInner>, EndpointInner>() {
            @Override
            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the EndpointInner object
     */
    public Observable<ServiceResponse<EndpointInner>> beginStopWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginStop(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>() {
                @Override
                public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<EndpointInner> clientResponse = beginStopDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<EndpointInner> beginStopDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<EndpointInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<EndpointInner>() { }.getType())
                .register(202, new TypeToken<EndpointInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void purgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        purgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().last().body();
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(purgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return purgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> purgeContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        Observable<Response<ResponseBody>> observable = service.purgeContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginPurgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        beginPurgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().single().body();
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginPurgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return beginPurgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginPurgeContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return service.beginPurgeContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginPurgeContentDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginPurgeContentDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void loadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        loadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().last().body();
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> loadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(loadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> loadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return loadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> loadContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        Observable<Response<ResponseBody>> observable = service.loadContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginLoadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        beginLoadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().single().body();
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginLoadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginLoadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginLoadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return beginLoadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginLoadContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return service.beginLoadContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginLoadContentDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginLoadContentDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ValidateCustomDomainOutputInner object if successful.
     */
    public ValidateCustomDomainOutputInner validateCustomDomain(String resourceGroupName, String profileName, String endpointName, String hostName) {
        return validateCustomDomainWithServiceResponseAsync(resourceGroupName, profileName, endpointName, hostName).toBlocking().single().body();
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ValidateCustomDomainOutputInner> validateCustomDomainAsync(String resourceGroupName, String profileName, String endpointName, String hostName, final ServiceCallback<ValidateCustomDomainOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateCustomDomainWithServiceResponseAsync(resourceGroupName, profileName, endpointName, hostName), serviceCallback);
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidateCustomDomainOutputInner object
     */
    public Observable<ValidateCustomDomainOutputInner> validateCustomDomainAsync(String resourceGroupName, String profileName, String endpointName, String hostName) {
        return validateCustomDomainWithServiceResponseAsync(resourceGroupName, profileName, endpointName, hostName).map(new Func1<ServiceResponse<ValidateCustomDomainOutputInner>, ValidateCustomDomainOutputInner>() {
            @Override
            public ValidateCustomDomainOutputInner call(ServiceResponse<ValidateCustomDomainOutputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostName The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidateCustomDomainOutputInner object
     */
    public Observable<ServiceResponse<ValidateCustomDomainOutputInner>> validateCustomDomainWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        ValidateCustomDomainInput customDomainProperties = new ValidateCustomDomainInput();
        customDomainProperties.withHostName(hostName);
        return service.validateCustomDomain(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateCustomDomainOutputInner>>>() {
                @Override
                public Observable<ServiceResponse<ValidateCustomDomainOutputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ValidateCustomDomainOutputInner> clientResponse = validateCustomDomainDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ValidateCustomDomainOutputInner> validateCustomDomainDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ValidateCustomDomainOutputInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ValidateCustomDomainOutputInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceUsageInner&gt; object if successful.
     */
    public PagedList<ResourceUsageInner> listResourceUsage(final String resourceGroupName, final String profileName, final String endpointName) {
        ServiceResponse<Page<ResourceUsageInner>> response = listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<ResourceUsageInner>(response.body()) {
            @Override
            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageAsync(final String resourceGroupName, final String profileName, final String endpointName, final ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName),
            new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                    return listResourceUsageNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceUsageInner&gt; object
     */
    public Observable<Page<ResourceUsageInner>> listResourceUsageAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listResourceUsageWithServiceResponseAsync(resourceGroupName, profileName, endpointName)
            .map(new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>() {
                @Override
                public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceUsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName)
            .concatMap(new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listResourceUsageNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
    ServiceResponse<PageImpl<ResourceUsageInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<ResourceUsageInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<ResourceUsageInner>> * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceUsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageSinglePageAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listResourceUsage(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceUsageInner>> result = listResourceUsageDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceUsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceUsageInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceUsageInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;EndpointInner&gt; object if successful.
     */
    public PagedList<EndpointInner> listByProfileNext(final String nextPageLink) {
        ServiceResponse<Page<EndpointInner>> response = listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EndpointInner>(response.body()) {
            @Override
            public Page<EndpointInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<EndpointInner>> listByProfileNextAsync(final String nextPageLink, final ServiceFuture<List<EndpointInner>> serviceFuture, final ListOperationCallback<EndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<EndpointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EndpointInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EndpointInner&gt; object
     */
    public Observable<Page<EndpointInner>> listByProfileNextAsync(final String nextPageLink) {
        return listByProfileNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<EndpointInner>>, Page<EndpointInner>>() {
                @Override
                public Page<EndpointInner> call(ServiceResponse<Page<EndpointInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;EndpointInner&gt; object
     */
    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileNextWithServiceResponseAsync(final String nextPageLink) {
        return listByProfileNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<EndpointInner>>, Observable<ServiceResponse<Page<EndpointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EndpointInner>>> call(ServiceResponse<Page<EndpointInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing CDN endpoints.
     *
    ServiceResponse<PageImpl<EndpointInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;EndpointInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EndpointInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<EndpointInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<EndpointInner>> result = listByProfileNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<EndpointInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<EndpointInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<EndpointInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<EndpointInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceUsageInner&gt; object if successful.
     */
    public PagedList<ResourceUsageInner> listResourceUsageNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceUsageInner>> response = listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceUsageInner>(response.body()) {
            @Override
            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceUsageInner>> serviceFuture, final ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listResourceUsageNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                    return listResourceUsageNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceUsageInner&gt; object
     */
    public Observable<Page<ResourceUsageInner>> listResourceUsageNextAsync(final String nextPageLink) {
        return listResourceUsageNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>() {
                @Override
                public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceUsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextWithServiceResponseAsync(final String nextPageLink) {
        return listResourceUsageNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listResourceUsageNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
    ServiceResponse<PageImpl<ResourceUsageInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceUsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listResourceUsageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceUsageInner>> result = listResourceUsageNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceUsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceUsageInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceUsageInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
