/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.CdnWebApplicationFirewallPolicyPatchParameters;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Policies.
 */
public class PoliciesInner implements InnerSupportsGet<CdnWebApplicationFirewallPolicyInner>, InnerSupportsDelete<Void> {
    /** The Retrofit service to perform REST calls. */
    private PoliciesService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of PoliciesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PoliciesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(PoliciesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Policies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PoliciesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Body CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Body CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("policyName") String policyName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object if successful.
     */
    public PagedList<CdnWebApplicationFirewallPolicyInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<CdnWebApplicationFirewallPolicyInner>(response.body()) {
            @Override
            public Page<CdnWebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<Page<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Page<CdnWebApplicationFirewallPolicyInner>>() {
                @Override
                public Page<CdnWebApplicationFirewallPolicyInner> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
    ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CdnWebApplicationFirewallPolicyInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CdnWebApplicationFirewallPolicyInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner getByResourceGroup(String resourceGroupName, String policyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single().body();
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieve protection policy with specified name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CdnWebApplicationFirewallPolicyInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CdnWebApplicationFirewallPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CdnWebApplicationFirewallPolicyInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner createOrUpdate(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).toBlocking().last().body();
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy), serviceCallback);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (cdnWebApplicationFirewallPolicy == null) {
            throw new IllegalArgumentException("Parameter cdnWebApplicationFirewallPolicy is required and cannot be null.");
        }
        Validator.validate(cdnWebApplicationFirewallPolicy);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), cdnWebApplicationFirewallPolicy, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType());
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner beginCreateOrUpdate(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).toBlocking().single().body();
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy), serviceCallback);
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update policy with specified rule set name within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param cdnWebApplicationFirewallPolicy Policy to be created.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (cdnWebApplicationFirewallPolicy == null) {
            throw new IllegalArgumentException("Parameter cdnWebApplicationFirewallPolicy is required and cannot be null.");
        }
        Validator.validate(cdnWebApplicationFirewallPolicy);
        return service.beginCreateOrUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), cdnWebApplicationFirewallPolicy, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CdnWebApplicationFirewallPolicyInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CdnWebApplicationFirewallPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CdnWebApplicationFirewallPolicyInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType())
                .register(201, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType())
                .register(202, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner update(String resourceGroupName, String policyName) {
        return updateWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().last().body();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName) {
        return updateWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Map<String, String> tags = null;
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType());
    }
    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner update(String resourceGroupName, String policyName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, policyName, tags).toBlocking().last().body();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, Map<String, String> tags, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, policyName, tags), serviceCallback);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, policyName, tags).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType());
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner beginUpdate(String resourceGroupName, String policyName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single().body();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Map<String, String> tags = null;
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(null);
        return service.beginUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CdnWebApplicationFirewallPolicyInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CdnWebApplicationFirewallPolicyInner object if successful.
     */
    public CdnWebApplicationFirewallPolicyInner beginUpdate(String resourceGroupName, String policyName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, policyName, tags).toBlocking().single().body();
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, Map<String, String> tags, final ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, policyName, tags), serviceCallback);
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, policyName, tags).map(new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>() {
            @Override
            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Update an existing CdnWebApplicationFirewallPolicy with the specified policy name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param tags CdnWebApplicationFirewallPolicy tags
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CdnWebApplicationFirewallPolicyInner object
     */
    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(tags);
        return service.beginUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CdnWebApplicationFirewallPolicyInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CdnWebApplicationFirewallPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CdnWebApplicationFirewallPolicyInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType())
                .register(202, new TypeToken<CdnWebApplicationFirewallPolicyInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String policyName) {
        deleteWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().last().body();
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String policyName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String policyName) {
        return deleteWithServiceResponseAsync(resourceGroupName, policyName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes Policy.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param policyName The name of the CdnWebApplicationFirewallPolicy.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object if successful.
     */
    public PagedList<CdnWebApplicationFirewallPolicyInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CdnWebApplicationFirewallPolicyInner>(response.body()) {
            @Override
            public Page<CdnWebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<CdnWebApplicationFirewallPolicyInner>> serviceFuture, final ListOperationCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<Page<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Page<CdnWebApplicationFirewallPolicyInner>>() {
                @Override
                public Page<CdnWebApplicationFirewallPolicyInner> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object
     */
    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the protection policies within a resource group.
     *
    ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CdnWebApplicationFirewallPolicyInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CdnWebApplicationFirewallPolicyInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CdnWebApplicationFirewallPolicyInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
