/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.SecretParameters;
import com.microsoft.azure.management.cdn.SecretProperties;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Secrets.
 */
public class SecretsInner {
    /** The Retrofit service to perform REST calls. */
    private SecretsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of SecretsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public SecretsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(SecretsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Secrets to be
     * used by Retrofit to perform actually REST calls.
     */
    interface SecretsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets listByProfile" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets")
        Observable<Response<ResponseBody>> listByProfile(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecretInner secret, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecretInner secret, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecretProperties secretProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body SecretProperties secretProperties, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("secretName") String secretName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets listByProfileNext" })
        @GET
        Observable<Response<ResponseBody>> listByProfileNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretInner&gt; object if successful.
     */
    public PagedList<SecretInner> listByProfile(final String resourceGroupName, final String profileName) {
        ServiceResponse<Page<SecretInner>> response = listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<SecretInner>(response.body()) {
            @Override
            public Page<SecretInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SecretInner>> listByProfileAsync(final String resourceGroupName, final String profileName, final ListOperationCallback<SecretInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileSinglePageAsync(resourceGroupName, profileName),
            new Func1<String, Observable<ServiceResponse<Page<SecretInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecretInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretInner&gt; object
     */
    public Observable<Page<SecretInner>> listByProfileAsync(final String resourceGroupName, final String profileName) {
        return listByProfileWithServiceResponseAsync(resourceGroupName, profileName)
            .map(new Func1<ServiceResponse<Page<SecretInner>>, Page<SecretInner>>() {
                @Override
                public Page<SecretInner> call(ServiceResponse<Page<SecretInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretInner&gt; object
     */
    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileWithServiceResponseAsync(final String resourceGroupName, final String profileName) {
        return listByProfileSinglePageAsync(resourceGroupName, profileName)
            .concatMap(new Func1<ServiceResponse<Page<SecretInner>>, Observable<ServiceResponse<Page<SecretInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecretInner>>> call(ServiceResponse<Page<SecretInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
    ServiceResponse<PageImpl<SecretInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<SecretInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SecretInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileSinglePageAsync(final String resourceGroupName, final String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecretInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SecretInner>> result = listByProfileDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SecretInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SecretInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SecretInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SecretInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner get(String resourceGroupName, String profileName, String secretName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single().body();
    }

    /**
     * Gets an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> getAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Gets an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<SecretInner> getAsync(String resourceGroupName, String profileName, String secretName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<ServiceResponse<SecretInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>() {
                @Override
                public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecretInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SecretInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SecretInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SecretInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner create(String resourceGroupName, String profileName, String secretName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().last().body();
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecretInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecretParameters parameters = null;
        SecretInner secret = new SecretInner();
        secret.withParameters(null);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>() { }.getType());
    }
    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner create(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().last().body();
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecretInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecretInner secret = new SecretInner();
        secret.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>() { }.getType());
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner beginCreate(String resourceGroupName, String profileName, String secretName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single().body();
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<ServiceResponse<SecretInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecretParameters parameters = null;
        SecretInner secret = new SecretInner();
        secret.withParameters(null);
        return service.beginCreate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>() {
                @Override
                public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecretInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner beginCreate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new Secret within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<ServiceResponse<SecretInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecretInner secret = new SecretInner();
        secret.withParameters(parameters);
        return service.beginCreate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>() {
                @Override
                public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecretInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SecretInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SecretInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SecretInner>() { }.getType())
                .register(201, new TypeToken<SecretInner>() { }.getType())
                .register(202, new TypeToken<SecretInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner update(String resourceGroupName, String profileName, String secretName) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().last().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecretInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecretParameters parameters = null;
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(null);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>() { }.getType());
    }
    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner update(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().last().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SecretInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>() { }.getType());
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner beginUpdate(String resourceGroupName, String profileName, String secretName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<ServiceResponse<SecretInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final SecretParameters parameters = null;
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(null);
        return service.beginUpdate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>() {
                @Override
                public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecretInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SecretInner object if successful.
     */
    public SecretInner beginUpdate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().single().body();
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, final ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map(new Func1<ServiceResponse<SecretInner>, SecretInner>() {
            @Override
            public SecretInner call(ServiceResponse<SecretInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing Secret within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param parameters object which contains secret parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SecretInner object
     */
    public Observable<ServiceResponse<SecretInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(parameters);
        return service.beginUpdate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>() {
                @Override
                public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SecretInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SecretInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SecretInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SecretInner>() { }.getType())
                .register(202, new TypeToken<SecretInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String secretName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().last().body();
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String secretName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String secretName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single().body();
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String secretName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String secretName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing Secret within profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param secretName Name of the Secret under the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SecretInner&gt; object if successful.
     */
    public PagedList<SecretInner> listByProfileNext(final String nextPageLink) {
        ServiceResponse<Page<SecretInner>> response = listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecretInner>(response.body()) {
            @Override
            public Page<SecretInner> nextPage(String nextPageLink) {
                return listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SecretInner>> listByProfileNextAsync(final String nextPageLink, final ServiceFuture<List<SecretInner>> serviceFuture, final ListOperationCallback<SecretInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByProfileNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SecretInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecretInner>>> call(String nextPageLink) {
                    return listByProfileNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretInner&gt; object
     */
    public Observable<Page<SecretInner>> listByProfileNextAsync(final String nextPageLink) {
        return listByProfileNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SecretInner>>, Page<SecretInner>>() {
                @Override
                public Page<SecretInner> call(ServiceResponse<Page<SecretInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SecretInner&gt; object
     */
    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileNextWithServiceResponseAsync(final String nextPageLink) {
        return listByProfileNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SecretInner>>, Observable<ServiceResponse<Page<SecretInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecretInner>>> call(ServiceResponse<Page<SecretInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByProfileNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists existing AzureFrontDoor secrets.
     *
    ServiceResponse<PageImpl<SecretInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SecretInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SecretInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SecretInner>> result = listByProfileNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SecretInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SecretInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SecretInner>, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SecretInner>>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
