/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.management.cdn.Status;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Output of the validated secret.
 */
public class ValidateSecretOutputInner {
    /**
     * The validation status. Possible values include: 'Valid', 'Invalid',
     * 'AccessDenied', 'CertificateExpired'.
     */
    @JsonProperty(value = "status")
    private Status status;

    /**
     * Detailed error message.
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the validation status. Possible values include: 'Valid', 'Invalid', 'AccessDenied', 'CertificateExpired'.
     *
     * @return the status value
     */
    public Status status() {
        return this.status;
    }

    /**
     * Set the validation status. Possible values include: 'Valid', 'Invalid', 'AccessDenied', 'CertificateExpired'.
     *
     * @param status the status value to set
     * @return the ValidateSecretOutputInner object itself.
     */
    public ValidateSecretOutputInner withStatus(Status status) {
        this.status = status;
        return this;
    }

    /**
     * Get detailed error message.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set detailed error message.
     *
     * @param message the message value to set
     * @return the ValidateSecretOutputInner object itself.
     */
    public ValidateSecretOutputInner withMessage(String message) {
        this.message = message;
        return this;
    }

}
