/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.ResourceReference;
import com.microsoft.azure.management.cdn.ValidateSecretInput;
import com.microsoft.azure.management.cdn.ValidateSecretType;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Validates.
 */
public class ValidatesInner {
    /** The Retrofit service to perform REST calls. */
    private ValidatesService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of ValidatesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ValidatesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(ValidatesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Validates to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ValidatesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Validates secretMethod" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateSecret")
        Observable<Response<ResponseBody>> secretMethod(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ValidateSecretInput validateSecretInput, @Header("User-Agent") String userAgent);

    }

    /**
     * Validate a Secret in the profile.
     *
     * @param secretSource The secret source.
     * @param secretType The secret type. Possible values include: 'UrlSigningKey', 'ManagedCertificate', 'CustomerCertificate'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws AfdErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ValidateSecretOutputInner object if successful.
     */
    public ValidateSecretOutputInner secretMethod(ResourceReference secretSource, ValidateSecretType secretType) {
        return secretMethodWithServiceResponseAsync(secretSource, secretType).toBlocking().single().body();
    }

    /**
     * Validate a Secret in the profile.
     *
     * @param secretSource The secret source.
     * @param secretType The secret type. Possible values include: 'UrlSigningKey', 'ManagedCertificate', 'CustomerCertificate'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ValidateSecretOutputInner> secretMethodAsync(ResourceReference secretSource, ValidateSecretType secretType, final ServiceCallback<ValidateSecretOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(secretMethodWithServiceResponseAsync(secretSource, secretType), serviceCallback);
    }

    /**
     * Validate a Secret in the profile.
     *
     * @param secretSource The secret source.
     * @param secretType The secret type. Possible values include: 'UrlSigningKey', 'ManagedCertificate', 'CustomerCertificate'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidateSecretOutputInner object
     */
    public Observable<ValidateSecretOutputInner> secretMethodAsync(ResourceReference secretSource, ValidateSecretType secretType) {
        return secretMethodWithServiceResponseAsync(secretSource, secretType).map(new Func1<ServiceResponse<ValidateSecretOutputInner>, ValidateSecretOutputInner>() {
            @Override
            public ValidateSecretOutputInner call(ServiceResponse<ValidateSecretOutputInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validate a Secret in the profile.
     *
     * @param secretSource The secret source.
     * @param secretType The secret type. Possible values include: 'UrlSigningKey', 'ManagedCertificate', 'CustomerCertificate'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidateSecretOutputInner object
     */
    public Observable<ServiceResponse<ValidateSecretOutputInner>> secretMethodWithServiceResponseAsync(ResourceReference secretSource, ValidateSecretType secretType) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (secretSource == null) {
            throw new IllegalArgumentException("Parameter secretSource is required and cannot be null.");
        }
        if (secretType == null) {
            throw new IllegalArgumentException("Parameter secretType is required and cannot be null.");
        }
        Validator.validate(secretSource);
        ValidateSecretInput validateSecretInput = new ValidateSecretInput();
        validateSecretInput.withSecretSource(secretSource);
        validateSecretInput.withSecretType(secretType);
        return service.secretMethod(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), validateSecretInput, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateSecretOutputInner>>>() {
                @Override
                public Observable<ServiceResponse<ValidateSecretOutputInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ValidateSecretOutputInner> clientResponse = secretMethodDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ValidateSecretOutputInner> secretMethodDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ValidateSecretOutputInner, AfdErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ValidateSecretOutputInner>() { }.getType())
                .registerError(AfdErrorResponseException.class)
                .build(response);
    }

}
