/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import org.joda.time.DateTime;
import java.util.List;
import com.microsoft.azure.management.cdn.WafMetricsResponseSeriesItem;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Waf Metrics Response.
 */
public class WafMetricsResponseInner {
    /**
     * The dateTimeBegin property.
     */
    @JsonProperty(value = "dateTimeBegin")
    private DateTime dateTimeBegin;

    /**
     * The dateTimeEnd property.
     */
    @JsonProperty(value = "dateTimeEnd")
    private DateTime dateTimeEnd;

    /**
     * Possible values include: 'PT5M', 'PT1H', 'P1D'.
     */
    @JsonProperty(value = "granularity")
    private String granularity;

    /**
     * The series property.
     */
    @JsonProperty(value = "series")
    private List<WafMetricsResponseSeriesItem> series;

    /**
     * Get the dateTimeBegin value.
     *
     * @return the dateTimeBegin value
     */
    public DateTime dateTimeBegin() {
        return this.dateTimeBegin;
    }

    /**
     * Set the dateTimeBegin value.
     *
     * @param dateTimeBegin the dateTimeBegin value to set
     * @return the WafMetricsResponseInner object itself.
     */
    public WafMetricsResponseInner withDateTimeBegin(DateTime dateTimeBegin) {
        this.dateTimeBegin = dateTimeBegin;
        return this;
    }

    /**
     * Get the dateTimeEnd value.
     *
     * @return the dateTimeEnd value
     */
    public DateTime dateTimeEnd() {
        return this.dateTimeEnd;
    }

    /**
     * Set the dateTimeEnd value.
     *
     * @param dateTimeEnd the dateTimeEnd value to set
     * @return the WafMetricsResponseInner object itself.
     */
    public WafMetricsResponseInner withDateTimeEnd(DateTime dateTimeEnd) {
        this.dateTimeEnd = dateTimeEnd;
        return this;
    }

    /**
     * Get possible values include: 'PT5M', 'PT1H', 'P1D'.
     *
     * @return the granularity value
     */
    public String granularity() {
        return this.granularity;
    }

    /**
     * Set possible values include: 'PT5M', 'PT1H', 'P1D'.
     *
     * @param granularity the granularity value to set
     * @return the WafMetricsResponseInner object itself.
     */
    public WafMetricsResponseInner withGranularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    /**
     * Get the series value.
     *
     * @return the series value
     */
    public List<WafMetricsResponseSeriesItem> series() {
        return this.series;
    }

    /**
     * Set the series value.
     *
     * @param series the series value to set
     * @return the WafMetricsResponseInner object itself.
     */
    public WafMetricsResponseInner withSeries(List<WafMetricsResponseSeriesItem> series) {
        this.series = series;
        return this;
    }

}
