/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.CdnWebApplicationFirewallPolicyPatchParameters;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.CdnWebApplicationFirewallPolicyInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PoliciesInner
implements InnerSupportsGet<CdnWebApplicationFirewallPolicyInner>,
InnerSupportsDelete<Void> {
    private PoliciesService service;
    private CdnManagementClientImpl client;

    public PoliciesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (PoliciesService)retrofit.create(PoliciesService.class);
        this.client = client;
    }

    public PagedList<CdnWebApplicationFirewallPolicyInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<CdnWebApplicationFirewallPolicyInner>((Page)response.body()){

            public Page<CdnWebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                return PoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Page<CdnWebApplicationFirewallPolicyInner>>(){

            public Page<CdnWebApplicationFirewallPolicyInner> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PoliciesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CdnWebApplicationFirewallPolicyInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CdnWebApplicationFirewallPolicyInner getByResourceGroup(String resourceGroupName, String policyName) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>(){

            public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CdnWebApplicationFirewallPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CdnWebApplicationFirewallPolicyInner createOrUpdate(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).toBlocking().last()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (cdnWebApplicationFirewallPolicy == null) {
            throw new IllegalArgumentException("Parameter cdnWebApplicationFirewallPolicy is required and cannot be null.");
        }
        Validator.validate((Object)((Object)cdnWebApplicationFirewallPolicy));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), cdnWebApplicationFirewallPolicy, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType());
    }

    public CdnWebApplicationFirewallPolicyInner beginCreateOrUpdate(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).toBlocking().single()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, policyName, cdnWebApplicationFirewallPolicy).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, CdnWebApplicationFirewallPolicyInner cdnWebApplicationFirewallPolicy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (cdnWebApplicationFirewallPolicy == null) {
            throw new IllegalArgumentException("Parameter cdnWebApplicationFirewallPolicy is required and cannot be null.");
        }
        Validator.validate((Object)((Object)cdnWebApplicationFirewallPolicy));
        return this.service.beginCreateOrUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), cdnWebApplicationFirewallPolicy, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>(){

            public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CdnWebApplicationFirewallPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType()).register(201, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType()).register(202, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CdnWebApplicationFirewallPolicyInner update(String resourceGroupName, String policyName) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().last()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType());
    }

    public CdnWebApplicationFirewallPolicyInner update(String resourceGroupName, String policyName, Map<String, String> tags) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, policyName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, Map<String, String> tags, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, policyName, tags), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, policyName, tags).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType());
    }

    public CdnWebApplicationFirewallPolicyInner beginUpdate(String resourceGroupName, String policyName) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().single()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(null);
        return this.service.beginUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>(){

            public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CdnWebApplicationFirewallPolicyInner beginUpdate(String resourceGroupName, String policyName, Map<String, String> tags) {
        return (CdnWebApplicationFirewallPolicyInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, policyName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, Map<String, String> tags, ServiceCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, policyName, tags), serviceCallback);
    }

    public Observable<CdnWebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, policyName, tags).map((Func1)new Func1<ServiceResponse<CdnWebApplicationFirewallPolicyInner>, CdnWebApplicationFirewallPolicyInner>(){

            public CdnWebApplicationFirewallPolicyInner call(ServiceResponse<CdnWebApplicationFirewallPolicyInner> response) {
                return (CdnWebApplicationFirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String policyName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        CdnWebApplicationFirewallPolicyPatchParameters cdnWebApplicationFirewallPolicyPatchParameters = new CdnWebApplicationFirewallPolicyPatchParameters();
        cdnWebApplicationFirewallPolicyPatchParameters.withTags(tags);
        return this.service.beginUpdate(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), cdnWebApplicationFirewallPolicyPatchParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>>>(){

            public Observable<ServiceResponse<CdnWebApplicationFirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CdnWebApplicationFirewallPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType()).register(202, new TypeToken<CdnWebApplicationFirewallPolicyInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String policyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, policyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String policyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, policyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String policyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, policyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String policyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (policyName == null) {
            throw new IllegalArgumentException("Parameter policyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, policyName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public PagedList<CdnWebApplicationFirewallPolicyInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CdnWebApplicationFirewallPolicyInner>((Page)response.body()){

            public Page<CdnWebApplicationFirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<CdnWebApplicationFirewallPolicyInner>> serviceFuture, ListOperationCallback<CdnWebApplicationFirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(String nextPageLink) {
                return PoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Page<CdnWebApplicationFirewallPolicyInner>>(){

            public Page<CdnWebApplicationFirewallPolicyInner> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<CdnWebApplicationFirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PoliciesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CdnWebApplicationFirewallPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CdnWebApplicationFirewallPolicyInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface PoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body CdnWebApplicationFirewallPolicyInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Body CdnWebApplicationFirewallPolicyInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body CdnWebApplicationFirewallPolicyPatchParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body CdnWebApplicationFirewallPolicyPatchParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/CdnWebApplicationFirewallPolicies/{policyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="policyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Policies listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

