/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.SecretParameters;
import com.microsoft.azure.management.cdn.SecretProperties;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.SecretInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SecretsInner {
    private SecretsService service;
    private CdnManagementClientImpl client;

    public SecretsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (SecretsService)retrofit.create(SecretsService.class);
        this.client = client;
    }

    public PagedList<SecretInner> listByProfile(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<SecretInner>((Page)response.body()){

            public Page<SecretInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SecretsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SecretInner>> listByProfileAsync(String resourceGroupName, String profileName, ListOperationCallback<SecretInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretInner>>>>(){

            public Observable<ServiceResponse<Page<SecretInner>>> call(String nextPageLink) {
                return SecretsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretInner>> listByProfileAsync(String resourceGroupName, String profileName) {
        return this.listByProfileWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<SecretInner>>, Page<SecretInner>>(){

            public Page<SecretInner> call(ServiceResponse<Page<SecretInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listByProfileSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<SecretInner>>, Observable<ServiceResponse<Page<SecretInner>>>>(){

            public Observable<ServiceResponse<Page<SecretInner>>> call(ServiceResponse<Page<SecretInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SecretsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretInner>>>>(){

            public Observable<ServiceResponse<Page<SecretInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SecretsInner.this.listByProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretInner>> listByProfileDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SecretInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public SecretInner get(String resourceGroupName, String profileName, String secretName) {
        return (SecretInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single()).body());
    }

    public ServiceFuture<SecretInner> getAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<SecretInner> getAsync(String resourceGroupName, String profileName, String secretName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>(){

            public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecretsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretInner> getDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecretInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public SecretInner create(String resourceGroupName, String profileName, String secretName) {
        return (SecretInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().last()).body());
    }

    public ServiceFuture<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecretInner secret = new SecretInner();
        secret.withParameters(null);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>(){}.getType());
    }

    public SecretInner create(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return (SecretInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    public Observable<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecretInner secret = new SecretInner();
        secret.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>(){}.getType());
    }

    public SecretInner beginCreate(String resourceGroupName, String profileName, String secretName) {
        return (SecretInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single()).body());
    }

    public ServiceFuture<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecretInner secret = new SecretInner();
        secret.withParameters(null);
        return this.service.beginCreate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>(){

            public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecretsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SecretInner beginCreate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return (SecretInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    public Observable<SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecretInner secret = new SecretInner();
        secret.withParameters(parameters);
        return this.service.beginCreate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secret, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>(){

            public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecretsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretInner> beginCreateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecretInner>(){}.getType()).register(201, new TypeToken<SecretInner>(){}.getType()).register(202, new TypeToken<SecretInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public SecretInner update(String resourceGroupName, String profileName, String secretName) {
        return (SecretInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().last()).body());
    }

    public ServiceFuture<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>(){}.getType());
    }

    public SecretInner update(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return (SecretInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    public Observable<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(parameters);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SecretInner>(){}.getType());
    }

    public SecretInner beginUpdate(String resourceGroupName, String profileName, String secretName) {
        return (SecretInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single()).body());
    }

    public ServiceFuture<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object parameters = null;
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(null);
        return this.service.beginUpdate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>(){

            public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecretsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SecretInner beginUpdate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return (SecretInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, ServiceCallback<SecretInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters), serviceCallback);
    }

    public Observable<SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, secretName, parameters).map((Func1)new Func1<ServiceResponse<SecretInner>, SecretInner>(){

            public SecretInner call(ServiceResponse<SecretInner> response) {
                return (SecretInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SecretInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(parameters);
        return this.service.beginUpdate(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), secretProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretInner>>>(){

            public Observable<ServiceResponse<SecretInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecretsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretInner> beginUpdateDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SecretInner>(){}.getType()).register(202, new TypeToken<SecretInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String secretName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String secretName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String secretName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String secretName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, secretName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String secretName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, secretName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, secretName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SecretsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    public PagedList<SecretInner> listByProfileNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecretInner>((Page)response.body()){

            public Page<SecretInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SecretsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SecretInner>> listByProfileNextAsync(String nextPageLink, ServiceFuture<List<SecretInner>> serviceFuture, ListOperationCallback<SecretInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretInner>>>>(){

            public Observable<ServiceResponse<Page<SecretInner>>> call(String nextPageLink) {
                return SecretsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretInner>> listByProfileNextAsync(String nextPageLink) {
        return this.listByProfileNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SecretInner>>, Page<SecretInner>>(){

            public Page<SecretInner> call(ServiceResponse<Page<SecretInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByProfileNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SecretInner>>, Observable<ServiceResponse<Page<SecretInner>>>>(){

            public Observable<ServiceResponse<Page<SecretInner>>> call(ServiceResponse<Page<SecretInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SecretsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretInner>>> listByProfileNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretInner>>>>(){

            public Observable<ServiceResponse<Page<SecretInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SecretsInner.this.listByProfileNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SecretInner>>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface SecretsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets listByProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets")
        public Observable<Response<ResponseBody>> listByProfile(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecretInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecretInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecretProperties var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body SecretProperties var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="secretName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Secrets listByProfileNext"})
        @GET
        public Observable<Response<ResponseBody>> listByProfileNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

