/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.cdn.AfdErrorResponseException;
import com.microsoft.azure.management.cdn.ResourceReference;
import com.microsoft.azure.management.cdn.ValidateSecretInput;
import com.microsoft.azure.management.cdn.ValidateSecretType;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.ValidateSecretOutputInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ValidatesInner {
    private ValidatesService service;
    private CdnManagementClientImpl client;

    public ValidatesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (ValidatesService)retrofit.create(ValidatesService.class);
        this.client = client;
    }

    public ValidateSecretOutputInner secretMethod(ResourceReference secretSource, ValidateSecretType secretType) {
        return (ValidateSecretOutputInner)((ServiceResponse)this.secretMethodWithServiceResponseAsync(secretSource, secretType).toBlocking().single()).body();
    }

    public ServiceFuture<ValidateSecretOutputInner> secretMethodAsync(ResourceReference secretSource, ValidateSecretType secretType, ServiceCallback<ValidateSecretOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.secretMethodWithServiceResponseAsync(secretSource, secretType), serviceCallback);
    }

    public Observable<ValidateSecretOutputInner> secretMethodAsync(ResourceReference secretSource, ValidateSecretType secretType) {
        return this.secretMethodWithServiceResponseAsync(secretSource, secretType).map((Func1)new Func1<ServiceResponse<ValidateSecretOutputInner>, ValidateSecretOutputInner>(){

            public ValidateSecretOutputInner call(ServiceResponse<ValidateSecretOutputInner> response) {
                return (ValidateSecretOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidateSecretOutputInner>> secretMethodWithServiceResponseAsync(ResourceReference secretSource, ValidateSecretType secretType) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (secretSource == null) {
            throw new IllegalArgumentException("Parameter secretSource is required and cannot be null.");
        }
        if (secretType == null) {
            throw new IllegalArgumentException("Parameter secretType is required and cannot be null.");
        }
        Validator.validate((Object)secretSource);
        ValidateSecretInput validateSecretInput = new ValidateSecretInput();
        validateSecretInput.withSecretSource(secretSource);
        validateSecretInput.withSecretType(secretType);
        return this.service.secretMethod(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), validateSecretInput, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateSecretOutputInner>>>(){

            public Observable<ServiceResponse<ValidateSecretOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ValidatesInner.this.secretMethodDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ValidateSecretOutputInner> secretMethodDelegate(Response<ResponseBody> response) throws AfdErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ValidateSecretOutputInner>(){}.getType()).registerError(AfdErrorResponseException.class).build(response);
    }

    static interface ValidatesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Validates secretMethod"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateSecret")
        public Observable<Response<ResponseBody>> secretMethod(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body ValidateSecretInput var4, @Header(value="User-Agent") String var5);
    }
}

