/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for AfdCertificateType.
 */
public final class AfdCertificateType extends ExpandableStringEnum<AfdCertificateType> {
    /** Static value CustomerCertificate for AfdCertificateType. */
    public static final AfdCertificateType CUSTOMER_CERTIFICATE = fromString("CustomerCertificate");

    /** Static value ManagedCertificate for AfdCertificateType. */
    public static final AfdCertificateType MANAGED_CERTIFICATE = fromString("ManagedCertificate");

    /**
     * Creates or finds a AfdCertificateType from its string representation.
     * @param name a name to look for
     * @return the corresponding AfdCertificateType
     */
    @JsonCreator
    public static AfdCertificateType fromString(String name) {
        return fromString(name, AfdCertificateType.class);
    }

    /**
     * @return known AfdCertificateType values
     */
    public static Collection<AfdCertificateType> values() {
        return values(AfdCertificateType.class);
    }
}
