/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the parameters for using CDN managed certificate for securing custom
 * domain.
 */
public class CdnCertificateSourceParameters {
    /**
     * The odatatype property.
     */
    @JsonProperty(value = "@odata\\.type", required = true)
    private String odatatype;

    /**
     * Type of certificate used. Possible values include: 'Shared',
     * 'Dedicated'.
     */
    @JsonProperty(value = "certificateType", required = true)
    private CertificateType certificateType;

    /**
     * Creates an instance of CdnCertificateSourceParameters class.
     */
    public CdnCertificateSourceParameters() {
        odatatype = "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters";
    }

    /**
     * Get the odatatype value.
     *
     * @return the odatatype value
     */
    public String odatatype() {
        return this.odatatype;
    }

    /**
     * Set the odatatype value.
     *
     * @param odatatype the odatatype value to set
     * @return the CdnCertificateSourceParameters object itself.
     */
    public CdnCertificateSourceParameters withOdatatype(String odatatype) {
        this.odatatype = odatatype;
        return this;
    }

    /**
     * Get type of certificate used. Possible values include: 'Shared', 'Dedicated'.
     *
     * @return the certificateType value
     */
    public CertificateType certificateType() {
        return this.certificateType;
    }

    /**
     * Set type of certificate used. Possible values include: 'Shared', 'Dedicated'.
     *
     * @param certificateType the certificateType value to set
     * @return the CdnCertificateSourceParameters object itself.
     */
    public CdnCertificateSourceParameters withCertificateType(CertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

}
