/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * settings for compression.
 */
public class CompressionSettings {
    /**
     * List of content types on which compression applies. The value should be
     * a valid MIME type.
     */
    @JsonProperty(value = "contentTypesToCompress")
    private List<String> contentTypesToCompress;

    /**
     * Indicates whether content compression is enabled on AzureFrontDoor.
     * Default value is false. If compression is enabled, content will be
     * served as compressed if user requests for a compressed version. Content
     * won't be compressed on AzureFrontDoor when requested content is smaller
     * than 1 byte or larger than 1 MB.
     */
    @JsonProperty(value = "isCompressionEnabled")
    private Boolean isCompressionEnabled;

    /**
     * Get list of content types on which compression applies. The value should be a valid MIME type.
     *
     * @return the contentTypesToCompress value
     */
    public List<String> contentTypesToCompress() {
        return this.contentTypesToCompress;
    }

    /**
     * Set list of content types on which compression applies. The value should be a valid MIME type.
     *
     * @param contentTypesToCompress the contentTypesToCompress value to set
     * @return the CompressionSettings object itself.
     */
    public CompressionSettings withContentTypesToCompress(List<String> contentTypesToCompress) {
        this.contentTypesToCompress = contentTypesToCompress;
        return this;
    }

    /**
     * Get indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     *
     * @return the isCompressionEnabled value
     */
    public Boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    /**
     * Set indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     *
     * @param isCompressionEnabled the isCompressionEnabled value to set
     * @return the CompressionSettings object itself.
     */
    public CompressionSettings withIsCompressionEnabled(Boolean isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

}
