/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonSubTypes;

/**
 * The JSON object that contains the properties to secure a custom domain.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "certificateSource", defaultImpl = CustomDomainHttpsParameters.class)
@JsonTypeName("CustomDomainHttpsParameters")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Cdn", value = CdnManagedHttpsParameters.class),
    @JsonSubTypes.Type(name = "AzureKeyVault", value = UserManagedHttpsParameters.class)
})
public class CustomDomainHttpsParameters {
    /**
     * Defines the TLS extension protocol that is used for secure delivery.
     * Possible values include: 'ServerNameIndication', 'IPBased'.
     */
    @JsonProperty(value = "protocolType", required = true)
    private ProtocolType protocolType;

    /**
     * TLS protocol version that will be used for Https. Possible values
     * include: 'None', 'TLS10', 'TLS12'.
     */
    @JsonProperty(value = "minimumTlsVersion")
    private MinimumTlsVersion minimumTlsVersion;

    /**
     * Get defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication', 'IPBased'.
     *
     * @return the protocolType value
     */
    public ProtocolType protocolType() {
        return this.protocolType;
    }

    /**
     * Set defines the TLS extension protocol that is used for secure delivery. Possible values include: 'ServerNameIndication', 'IPBased'.
     *
     * @param protocolType the protocolType value to set
     * @return the CustomDomainHttpsParameters object itself.
     */
    public CustomDomainHttpsParameters withProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    /**
     * Get tLS protocol version that will be used for Https. Possible values include: 'None', 'TLS10', 'TLS12'.
     *
     * @return the minimumTlsVersion value
     */
    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    /**
     * Set tLS protocol version that will be used for Https. Possible values include: 'None', 'TLS10', 'TLS12'.
     *
     * @param minimumTlsVersion the minimumTlsVersion value to set
     * @return the CustomDomainHttpsParameters object itself.
     */
    public CustomDomainHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

}
