/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Customer Certificate used for https.
 */
public class CustomerCertificate extends Certificate {
    /**
     * Certificate version.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * Certificate issuing authority.
     */
    @JsonProperty(value = "certificateAuthority")
    private String certificateAuthority;

    /**
     * Complete Url to the certificate.
     */
    @JsonProperty(value = "certificateUrl", required = true)
    private String certificateUrl;

    /**
     * Whether to use the latest version for the certificate.
     */
    @JsonProperty(value = "useLatestVersion")
    private Boolean useLatestVersion;

    /**
     * The list of SANs.
     */
    @JsonProperty(value = "subjectAlternativeNames")
    private List<String> subjectAlternativeNames;

    /**
     * Get certificate version.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Set certificate version.
     *
     * @param version the version value to set
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get certificate issuing authority.
     *
     * @return the certificateAuthority value
     */
    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Set certificate issuing authority.
     *
     * @param certificateAuthority the certificateAuthority value to set
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    /**
     * Get complete Url to the certificate.
     *
     * @return the certificateUrl value
     */
    public String certificateUrl() {
        return this.certificateUrl;
    }

    /**
     * Set complete Url to the certificate.
     *
     * @param certificateUrl the certificateUrl value to set
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    /**
     * Get whether to use the latest version for the certificate.
     *
     * @return the useLatestVersion value
     */
    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    /**
     * Set whether to use the latest version for the certificate.
     *
     * @param useLatestVersion the useLatestVersion value to set
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    /**
     * Get the list of SANs.
     *
     * @return the subjectAlternativeNames value
     */
    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    /**
     * Set the list of SANs.
     *
     * @param subjectAlternativeNames the subjectAlternativeNames value to set
     * @return the CustomerCertificate object itself.
     */
    public CustomerCertificate withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

}
