/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The JSON object that contains the properties to validate a domain.
 */
public class DomainValidationProperties {
    /**
     * Challenge used for DNS TXT record or file based validation.
     */
    @JsonProperty(value = "validationToken", access = JsonProperty.Access.WRITE_ONLY)
    private String validationToken;

    /**
     * The date time that the token expires.
     */
    @JsonProperty(value = "expirationDate", access = JsonProperty.Access.WRITE_ONLY)
    private String expirationDate;

    /**
     * Get challenge used for DNS TXT record or file based validation.
     *
     * @return the validationToken value
     */
    public String validationToken() {
        return this.validationToken;
    }

    /**
     * Get the date time that the token expires.
     *
     * @return the expirationDate value
     */
    public String expirationDate() {
        return this.expirationDate;
    }

}
