/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the parameters for the request header action.
 */
public class HeaderActionParameters {
    /**
     * The odatatype property.
     */
    @JsonProperty(value = "@odata\\.type", required = true)
    private String odatatype;

    /**
     * Action to perform. Possible values include: 'Append', 'Overwrite',
     * 'Delete'.
     */
    @JsonProperty(value = "headerAction", required = true)
    private HeaderAction headerAction;

    /**
     * Name of the header to modify.
     */
    @JsonProperty(value = "headerName", required = true)
    private String headerName;

    /**
     * Value for the specified action.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Creates an instance of HeaderActionParameters class.
     */
    public HeaderActionParameters() {
        odatatype = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters";
    }

    /**
     * Get the odatatype value.
     *
     * @return the odatatype value
     */
    public String odatatype() {
        return this.odatatype;
    }

    /**
     * Set the odatatype value.
     *
     * @param odatatype the odatatype value to set
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withOdatatype(String odatatype) {
        this.odatatype = odatatype;
        return this;
    }

    /**
     * Get action to perform. Possible values include: 'Append', 'Overwrite', 'Delete'.
     *
     * @return the headerAction value
     */
    public HeaderAction headerAction() {
        return this.headerAction;
    }

    /**
     * Set action to perform. Possible values include: 'Append', 'Overwrite', 'Delete'.
     *
     * @param headerAction the headerAction value to set
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withHeaderAction(HeaderAction headerAction) {
        this.headerAction = headerAction;
        return this;
    }

    /**
     * Get name of the header to modify.
     *
     * @return the headerName value
     */
    public String headerName() {
        return this.headerName;
    }

    /**
     * Set name of the header to modify.
     *
     * @param headerName the headerName value to set
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    /**
     * Get value for the specified action.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set value for the specified action.
     *
     * @param value the value value to set
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withValue(String value) {
        this.value = value;
        return this;
    }

}
