/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes the parameters for using a user's KeyVault for URL Signing Key.
 */
public class KeyVaultSigningKeyParameters {
    /**
     * The odatatype property.
     */
    @JsonProperty(value = "@odata\\.type", required = true)
    private String odatatype;

    /**
     * Subscription Id of the user's Key Vault containing the secret.
     */
    @JsonProperty(value = "subscriptionId", required = true)
    private String subscriptionId;

    /**
     * Resource group of the user's Key Vault containing the secret.
     */
    @JsonProperty(value = "resourceGroupName", required = true)
    private String resourceGroupName;

    /**
     * The name of the user's Key Vault containing the secret.
     */
    @JsonProperty(value = "vaultName", required = true)
    private String vaultName;

    /**
     * The name of secret in Key Vault.
     */
    @JsonProperty(value = "secretName", required = true)
    private String secretName;

    /**
     * The version(GUID) of secret in Key Vault.
     */
    @JsonProperty(value = "secretVersion", required = true)
    private String secretVersion;

    /**
     * Creates an instance of KeyVaultSigningKeyParameters class.
    public KeyVaultSigningKeyParameters() {
        odatatype = "#Microsoft.Azure.Cdn.Models.KeyVaultSigningKeyParameters";
    }

    /**
     * Get the odatatype value.
     *
     * @return the odatatype value
     */
    public String odatatype() {
        return this.odatatype;
    }

    /**
     * Set the odatatype value.
     *
     * @param odatatype the odatatype value to set
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withOdatatype(String odatatype) {
        this.odatatype = odatatype;
        return this;
    }

    /**
     * Get subscription Id of the user's Key Vault containing the secret.
     *
     * @return the subscriptionId value
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set subscription Id of the user's Key Vault containing the secret.
     *
     * @param subscriptionId the subscriptionId value to set
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get resource group of the user's Key Vault containing the secret.
     *
     * @return the resourceGroupName value
     */
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    /**
     * Set resource group of the user's Key Vault containing the secret.
     *
     * @param resourceGroupName the resourceGroupName value to set
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    /**
     * Get the name of the user's Key Vault containing the secret.
     *
     * @return the vaultName value
     */
    public String vaultName() {
        return this.vaultName;
    }

    /**
     * Set the name of the user's Key Vault containing the secret.
     *
     * @param vaultName the vaultName value to set
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    /**
     * Get the name of secret in Key Vault.
     *
     * @return the secretName value
     */
    public String secretName() {
        return this.secretName;
    }

    /**
     * Set the name of secret in Key Vault.
     *
     * @param secretName the secretName value to set
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    /**
     * Get the version(GUID) of secret in Key Vault.
     *
     * @return the secretVersion value
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the version(GUID) of secret in Key Vault.
     *
     * @param secretVersion the secretVersion value to set
     * @return the KeyVaultSigningKeyParameters object itself.
     */
    public KeyVaultSigningKeyParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

}
