/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * settings for security policy patterns to match.
 */
public class SecurityPolicyWebApplicationFirewallAssociation {
    /**
     * List of domains.
     */
    @JsonProperty(value = "domains")
    private List<ResourceReference> domains;

    /**
     * List of paths.
     */
    @JsonProperty(value = "patternsToMatch")
    private List<String> patternsToMatch;

    /**
     * Get list of domains.
     *
     * @return the domains value
     */
    public List<ResourceReference> domains() {
        return this.domains;
    }

    /**
     * Set list of domains.
     *
     * @param domains the domains value to set
     * @return the SecurityPolicyWebApplicationFirewallAssociation object itself.
     */
    public SecurityPolicyWebApplicationFirewallAssociation withDomains(List<ResourceReference> domains) {
        this.domains = domains;
        return this;
    }

    /**
     * Get list of paths.
     *
     * @return the patternsToMatch value
     */
    public List<String> patternsToMatch() {
        return this.patternsToMatch;
    }

    /**
     * Set list of paths.
     *
     * @param patternsToMatch the patternsToMatch value to set
     * @return the SecurityPolicyWebApplicationFirewallAssociation object itself.
     */
    public SecurityPolicyWebApplicationFirewallAssociation withPatternsToMatch(List<String> patternsToMatch) {
        this.patternsToMatch = patternsToMatch;
        return this;
    }

}
