/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The json object containing security policy waf parameters.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type", defaultImpl = SecurityPolicyWebApplicationFirewallParameters.class)
@JsonTypeName("WebApplicationFirewall")
public class SecurityPolicyWebApplicationFirewallParameters extends SecurityPolicyParameters {
    /**
     * Resource ID.
     */
    @JsonProperty(value = "wafPolicy")
    private ResourceReference wafPolicy;

    /**
     * Waf associations.
     */
    @JsonProperty(value = "associations")
    private List<SecurityPolicyWebApplicationFirewallAssociation> associations;

    /**
     * Get resource ID.
     *
     * @return the wafPolicy value
     */
    public ResourceReference wafPolicy() {
        return this.wafPolicy;
    }

    /**
     * Set resource ID.
     *
     * @param wafPolicy the wafPolicy value to set
     * @return the SecurityPolicyWebApplicationFirewallParameters object itself.
     */
    public SecurityPolicyWebApplicationFirewallParameters withWafPolicy(ResourceReference wafPolicy) {
        this.wafPolicy = wafPolicy;
        return this;
    }

    /**
     * Get waf associations.
     *
     * @return the associations value
     */
    public List<SecurityPolicyWebApplicationFirewallAssociation> associations() {
        return this.associations;
    }

    /**
     * Set waf associations.
     *
     * @param associations the associations value to set
     * @return the SecurityPolicyWebApplicationFirewallParameters object itself.
     */
    public SecurityPolicyWebApplicationFirewallParameters withAssociations(List<SecurityPolicyWebApplicationFirewallAssociation> associations) {
        this.associations = associations;
        return this;
    }

}
