/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The pricing tier (defines a CDN provider, feature list and rate) of the CDN
 * profile.
 */
public class Sku {
    /**
     * Name of the pricing tier. Possible values include: 'Standard_Verizon',
     * 'Premium_Verizon', 'Custom_Verizon', 'Standard_Akamai',
     * 'Standard_ChinaCdn', 'Standard_Microsoft', 'Premium_ChinaCdn',
     * 'Standard_AzureFrontDoor', 'Premium_AzureFrontDoor',
     * 'Standard_955BandWidth_ChinaCdn', 'Standard_AvgBandWidth_ChinaCdn',
     * 'StandardPlus_ChinaCdn', 'StandardPlus_955BandWidth_ChinaCdn',
     * 'StandardPlus_AvgBandWidth_ChinaCdn'.
     */
    @JsonProperty(value = "name")
    private SkuName name;

    /**
     * Get name of the pricing tier. Possible values include: 'Standard_Verizon', 'Premium_Verizon', 'Custom_Verizon', 'Standard_Akamai', 'Standard_ChinaCdn', 'Standard_Microsoft', 'Premium_ChinaCdn', 'Standard_AzureFrontDoor', 'Premium_AzureFrontDoor', 'Standard_955BandWidth_ChinaCdn', 'Standard_AvgBandWidth_ChinaCdn', 'StandardPlus_ChinaCdn', 'StandardPlus_955BandWidth_ChinaCdn', 'StandardPlus_AvgBandWidth_ChinaCdn'.
     *
     * @return the name value
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set name of the pricing tier. Possible values include: 'Standard_Verizon', 'Premium_Verizon', 'Custom_Verizon', 'Standard_Akamai', 'Standard_ChinaCdn', 'Standard_Microsoft', 'Premium_ChinaCdn', 'Standard_AzureFrontDoor', 'Premium_AzureFrontDoor', 'Standard_955BandWidth_ChinaCdn', 'Standard_AvgBandWidth_ChinaCdn', 'StandardPlus_ChinaCdn', 'StandardPlus_955BandWidth_ChinaCdn', 'StandardPlus_AvgBandWidth_ChinaCdn'.
     *
     * @param name the name value to set
     * @return the Sku object itself.
     */
    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

}
