/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.management.cdn.ResourceReference;
import com.microsoft.azure.management.cdn.EnabledState;
import com.microsoft.azure.management.cdn.AfdProvisioningState;
import com.microsoft.azure.management.cdn.DeploymentStatus;
import com.microsoft.azure.management.cdn.SystemData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * CDN origin is the source of the content being delivered via CDN. When the
 * edge nodes represented by an endpoint do not have the requested content
 * cached, they attempt to fetch it from one or more of the configured origins.
 */
@JsonFlatten
public class AFDOriginInner extends ProxyResource {
    /**
     * Resource reference to the Azure origin resource.
     */
    @JsonProperty(value = "properties.azureOrigin")
    private ResourceReference azureOrigin;

    /**
     * The address of the origin. Domain names, IPv4 addresses, and IPv6
     * addresses are supported.This should be unique across all origins in an
     * endpoint.
     */
    @JsonProperty(value = "properties.hostName", required = true)
    private String hostName;

    /**
     * The value of the HTTP port. Must be between 1 and 65535.
     */
    @JsonProperty(value = "properties.httpPort")
    private Integer httpPort;

    /**
     * The value of the HTTPS port. Must be between 1 and 65535.
     */
    @JsonProperty(value = "properties.httpsPort")
    private Integer httpsPort;

    /**
     * The host header value sent to the origin with each request. If you leave
     * this blank, the request hostname determines this value. Azure CDN
     * origins, such as Web Apps, Blob Storage, and Cloud Services require this
     * host header value to match the origin hostname by default. This
     * overrides the host header defined at Endpoint.
     */
    @JsonProperty(value = "properties.originHostHeader")
    private String originHostHeader;

    /**
     * Priority of origin in given origin group for load balancing. Higher
     * priorities will not be used for load balancing if any lower priority
     * origin is healthy.Must be between 1 and 5.
     */
    @JsonProperty(value = "properties.priority")
    private Integer priority;

    /**
     * Weight of the origin in given origin group for load balancing. Must be
     * between 1 and 1000.
     */
    @JsonProperty(value = "properties.weight")
    private Integer weight;

    /**
     * The properties of the private link resource for private origin.
     */
    @JsonProperty(value = "properties.sharedPrivateLinkResource")
    private Object sharedPrivateLinkResource;

    /**
     * Whether to enable health probes to be made against backends defined
     * under backendPools. Health probes can only be disabled if there is a
     * single enabled backend in single enabled backend pool. Possible values
     * include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.enabledState")
    private EnabledState enabledState;

    /**
     * Provisioning status. Possible values include: 'Succeeded', 'Failed',
     * 'Updating', 'Deleting', 'Creating'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;

    /**
     * Possible values include: 'NotStarted', 'InProgress', 'Succeeded',
     * 'Failed'.
     */
    @JsonProperty(value = "properties.deploymentStatus", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;

    /**
     * The systemData property.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get resource reference to the Azure origin resource.
     *
     * @return the azureOrigin value
     */
    public ResourceReference azureOrigin() {
        return this.azureOrigin;
    }

    /**
     * Set resource reference to the Azure origin resource.
     *
     * @param azureOrigin the azureOrigin value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withAzureOrigin(ResourceReference azureOrigin) {
        this.azureOrigin = azureOrigin;
        return this;
    }

    /**
     * Get the address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     *
     * @return the hostName value
     */
    public String hostName() {
        return this.hostName;
    }

    /**
     * Set the address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across all origins in an endpoint.
     *
     * @param hostName the hostName value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    /**
     * Get the value of the HTTP port. Must be between 1 and 65535.
     *
     * @return the httpPort value
     */
    public Integer httpPort() {
        return this.httpPort;
    }

    /**
     * Set the value of the HTTP port. Must be between 1 and 65535.
     *
     * @param httpPort the httpPort value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    /**
     * Get the value of the HTTPS port. Must be between 1 and 65535.
     *
     * @return the httpsPort value
     */
    public Integer httpsPort() {
        return this.httpsPort;
    }

    /**
     * Set the value of the HTTPS port. Must be between 1 and 65535.
     *
     * @param httpsPort the httpsPort value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withHttpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    /**
     * Get the host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint.
     *
     * @return the originHostHeader value
     */
    public String originHostHeader() {
        return this.originHostHeader;
    }

    /**
     * Set the host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint.
     *
     * @param originHostHeader the originHostHeader value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    /**
     * Get priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
     *
     * @return the priority value
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
     *
     * @param priority the priority value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get weight of the origin in given origin group for load balancing. Must be between 1 and 1000.
     *
     * @return the weight value
     */
    public Integer weight() {
        return this.weight;
    }

    /**
     * Set weight of the origin in given origin group for load balancing. Must be between 1 and 1000.
     *
     * @param weight the weight value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the properties of the private link resource for private origin.
     *
     * @return the sharedPrivateLinkResource value
     */
    public Object sharedPrivateLinkResource() {
        return this.sharedPrivateLinkResource;
    }

    /**
     * Set the properties of the private link resource for private origin.
     *
     * @param sharedPrivateLinkResource the sharedPrivateLinkResource value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withSharedPrivateLinkResource(Object sharedPrivateLinkResource) {
        this.sharedPrivateLinkResource = sharedPrivateLinkResource;
        return this;
    }

    /**
     * Get whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the enabledState value
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param enabledState the enabledState value to set
     * @return the AFDOriginInner object itself.
     */
    public AFDOriginInner withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Get provisioning status. Possible values include: 'Succeeded', 'Failed', 'Updating', 'Deleting', 'Creating'.
     *
     * @return the provisioningState value
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get possible values include: 'NotStarted', 'InProgress', 'Succeeded', 'Failed'.
     *
     * @return the deploymentStatus value
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the systemData value.
     *
     * @return the systemData value
     */
    public SystemData systemData() {
        return this.systemData;
    }

}
