/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.OriginGroupUpdateParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in OriginGroups.
 */
public class OriginGroupsInner {
    /** The Retrofit service to perform REST calls. */
    private OriginGroupsService service;
    /** The service client containing this operation class. */
    private CdnManagementClientImpl client;

    /**
     * Initializes an instance of OriginGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public OriginGroupsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = retrofit.create(OriginGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for OriginGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface OriginGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups listByEndpoint" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups")
        Observable<Response<ResponseBody>> listByEndpoint(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Body OriginGroupInner originGroup, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Body OriginGroupInner originGroup, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Body OriginGroupUpdateParameters originGroupUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Body OriginGroupUpdateParameters originGroupUpdateProperties, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("profileName") String profileName, @Path("endpointName") String endpointName, @Path("originGroupName") String originGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.OriginGroups listByEndpointNext" })
        @GET
        Observable<Response<ResponseBody>> listByEndpointNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;OriginGroupInner&gt; object if successful.
     */
    public PagedList<OriginGroupInner> listByEndpoint(final String resourceGroupName, final String profileName, final String endpointName) {
        ServiceResponse<Page<OriginGroupInner>> response = listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<OriginGroupInner>(response.body()) {
            @Override
            public Page<OriginGroupInner> nextPage(String nextPageLink) {
                return listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OriginGroupInner>> listByEndpointAsync(final String resourceGroupName, final String profileName, final String endpointName, final ListOperationCallback<OriginGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName),
            new Func1<String, Observable<ServiceResponse<Page<OriginGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OriginGroupInner>>> call(String nextPageLink) {
                    return listByEndpointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OriginGroupInner&gt; object
     */
    public Observable<Page<OriginGroupInner>> listByEndpointAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listByEndpointWithServiceResponseAsync(resourceGroupName, profileName, endpointName)
            .map(new Func1<ServiceResponse<Page<OriginGroupInner>>, Page<OriginGroupInner>>() {
                @Override
                public Page<OriginGroupInner> call(ServiceResponse<Page<OriginGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OriginGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointWithServiceResponseAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        return listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName)
            .concatMap(new Func1<ServiceResponse<Page<OriginGroupInner>>, Observable<ServiceResponse<Page<OriginGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OriginGroupInner>>> call(ServiceResponse<Page<OriginGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEndpointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
    ServiceResponse<PageImpl<OriginGroupInner>> * @param resourceGroupName Name of the Resource group within the Azure subscription.
    ServiceResponse<PageImpl<OriginGroupInner>> * @param profileName Name of the CDN profile which is unique within the resource group.
    ServiceResponse<PageImpl<OriginGroupInner>> * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;OriginGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointSinglePageAsync(final String resourceGroupName, final String profileName, final String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByEndpoint(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OriginGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OriginGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<OriginGroupInner>> result = listByEndpointDelegate(response);
                        return Observable.just(new ServiceResponse<Page<OriginGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<OriginGroupInner>> listByEndpointDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<OriginGroupInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<OriginGroupInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OriginGroupInner object if successful.
     */
    public OriginGroupInner get(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).toBlocking().single().body();
    }

    /**
     * Gets an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OriginGroupInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, final ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName), serviceCallback);
    }

    /**
     * Gets an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OriginGroupInner object
     */
    public Observable<OriginGroupInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).map(new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>() {
            @Override
            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OriginGroupInner object
     */
    public Observable<ServiceResponse<OriginGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<OriginGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OriginGroupInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OriginGroupInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OriginGroupInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OriginGroupInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OriginGroupInner object if successful.
     */
    public OriginGroupInner create(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).toBlocking().last().body();
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OriginGroupInner> createAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, final ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup), serviceCallback);
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OriginGroupInner> createAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).map(new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>() {
            @Override
            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OriginGroupInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroup == null) {
            throw new IllegalArgumentException("Parameter originGroup is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(originGroup);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroup, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OriginGroupInner>() { }.getType());
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OriginGroupInner object if successful.
     */
    public OriginGroupInner beginCreate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).toBlocking().single().body();
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, final ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup), serviceCallback);
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OriginGroupInner object
     */
    public Observable<OriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).map(new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>() {
            @Override
            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new origin group within the specified endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OriginGroupInner object
     */
    public Observable<ServiceResponse<OriginGroupInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroup == null) {
            throw new IllegalArgumentException("Parameter originGroup is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(originGroup);
        return service.beginCreate(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroup, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<OriginGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OriginGroupInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OriginGroupInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OriginGroupInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OriginGroupInner>() { }.getType())
                .register(201, new TypeToken<OriginGroupInner>() { }.getType())
                .register(202, new TypeToken<OriginGroupInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OriginGroupInner object if successful.
     */
    public OriginGroupInner update(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).toBlocking().last().body();
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OriginGroupInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, final ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OriginGroupInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).map(new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>() {
            @Override
            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OriginGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroupUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(originGroupUpdateProperties);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroupUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<OriginGroupInner>() { }.getType());
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OriginGroupInner object if successful.
     */
    public OriginGroupInner beginUpdate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).toBlocking().single().body();
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, final ServiceCallback<OriginGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties), serviceCallback);
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OriginGroupInner object
     */
    public Observable<OriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).map(new Func1<ServiceResponse<OriginGroupInner>, OriginGroupInner>() {
            @Override
            public OriginGroupInner call(ServiceResponse<OriginGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroupUpdateProperties Origin group properties
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OriginGroupInner object
     */
    public Observable<ServiceResponse<OriginGroupInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (originGroupUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(originGroupUpdateProperties);
        return service.beginUpdate(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), originGroupUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OriginGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<OriginGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OriginGroupInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OriginGroupInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OriginGroupInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OriginGroupInner>() { }.getType())
                .register(202, new TypeToken<OriginGroupInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).toBlocking().last().body();
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName), serviceCallback);
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).toBlocking().single().body();
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName), serviceCallback);
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an existing origin group within an endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (originGroupName == null) {
            throw new IllegalArgumentException("Parameter originGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, profileName, endpointName, originGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;OriginGroupInner&gt; object if successful.
     */
    public PagedList<OriginGroupInner> listByEndpointNext(final String nextPageLink) {
        ServiceResponse<Page<OriginGroupInner>> response = listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OriginGroupInner>(response.body()) {
            @Override
            public Page<OriginGroupInner> nextPage(String nextPageLink) {
                return listByEndpointNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OriginGroupInner>> listByEndpointNextAsync(final String nextPageLink, final ServiceFuture<List<OriginGroupInner>> serviceFuture, final ListOperationCallback<OriginGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByEndpointNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<OriginGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OriginGroupInner>>> call(String nextPageLink) {
                    return listByEndpointNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OriginGroupInner&gt; object
     */
    public Observable<Page<OriginGroupInner>> listByEndpointNextAsync(final String nextPageLink) {
        return listByEndpointNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<OriginGroupInner>>, Page<OriginGroupInner>>() {
                @Override
                public Page<OriginGroupInner> call(ServiceResponse<Page<OriginGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;OriginGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointNextWithServiceResponseAsync(final String nextPageLink) {
        return listByEndpointNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<OriginGroupInner>>, Observable<ServiceResponse<Page<OriginGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OriginGroupInner>>> call(ServiceResponse<Page<OriginGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByEndpointNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the existing origin groups within an endpoint.
     *
    ServiceResponse<PageImpl<OriginGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;OriginGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<OriginGroupInner>>> listByEndpointNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByEndpointNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OriginGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<OriginGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<OriginGroupInner>> result = listByEndpointNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<OriginGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<OriginGroupInner>> listByEndpointNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<OriginGroupInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<OriginGroupInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
